/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.operation;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.image.operation.ImageScaleOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public class ImageCropOperation
implements IImageOperation {
    private final float x;
    private final float y;
    private final float width;
    private final float height;

    public ImageCropOperation(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public static IOptional<ImageCropOperation, RuntimeException> aggregate(IObjectList<IImageOperation> operations) {
        ImageScaleOperation scaleOperation = null;
        ImageCropOperation cropOperation = null;
        for (IImageOperation operation : operations) {
            if (operation instanceof ImageScaleOperation) {
                scaleOperation = scaleOperation == null ? (ImageScaleOperation)operation : scaleOperation.adjust((ImageScaleOperation)operation);
            }
            if (!(operation instanceof ImageCropOperation)) continue;
            if (cropOperation == null) {
                cropOperation = ImageCropOperation.transform(scaleOperation, (ImageCropOperation)operation);
                continue;
            }
            ImageCropOperation other = ImageCropOperation.transform(scaleOperation, (ImageCropOperation)operation);
            cropOperation = new ImageCropOperation(cropOperation.getX() + other.getX(), cropOperation.getY() + other.getY(), other.getWidth(), other.getHeight());
        }
        return Optional.of(cropOperation);
    }

    private static ImageCropOperation transform(ImageScaleOperation scaleOperation, ImageCropOperation cropOperation) {
        if (scaleOperation == null) {
            return cropOperation;
        }
        Rectangle2D.Float rectangle = new Rectangle2D.Float(cropOperation.getX(), cropOperation.getY(), cropOperation.getWidth(), cropOperation.getHeight());
        AffineTransform transform = AffineTransform.getScaleInstance(1.0f / scaleOperation.getWidthFactor(), 1.0f / scaleOperation.getHeightFactor());
        Shape shape = transform.createTransformedShape(rectangle);
        Rectangle bounds = shape.getBounds();
        return new ImageCropOperation((float)bounds.getX(), (float)bounds.getY(), (float)bounds.getWidth(), (float)bounds.getHeight());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.height);
        result = 31 * result + Float.floatToIntBits(this.width);
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageCropOperation other = (ImageCropOperation)obj;
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (Float.floatToIntBits(this.width) != Float.floatToIntBits(other.width)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }

    public Rectangle getBounds() {
        return new Rectangle2D.Float(this.x, this.y, this.width, this.height).getBounds();
    }
}

