/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.operation;

import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public class ImageScaleOperation
implements IImageOperation {
    private final float widthFactor;
    private final float heightFactor;

    public ImageScaleOperation(float widthFactor, float heightFactor) {
        this.widthFactor = widthFactor;
        this.heightFactor = heightFactor;
    }

    public float getWidthFactor() {
        return this.widthFactor;
    }

    public float getHeightFactor() {
        return this.heightFactor;
    }

    public static IOptional<ImageScaleOperation, RuntimeException> aggregate(IObjectList<IImageOperation> operations) {
        ImageScaleOperation scaleOperation = null;
        for (IImageOperation operation : operations) {
            if (!(operation instanceof ImageScaleOperation)) continue;
            if (scaleOperation == null) {
                scaleOperation = (ImageScaleOperation)operation;
                continue;
            }
            scaleOperation = scaleOperation.adjust((ImageScaleOperation)operation);
        }
        return Optional.of(scaleOperation);
    }

    ImageScaleOperation adjust(ImageScaleOperation operation) {
        return new ImageScaleOperation(operation.getWidthFactor() * this.widthFactor, operation.getHeightFactor() * this.heightFactor);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.heightFactor);
        result = 31 * result + Float.floatToIntBits(this.widthFactor);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageScaleOperation other = (ImageScaleOperation)obj;
        if (Float.floatToIntBits(this.heightFactor) != Float.floatToIntBits(other.heightFactor)) {
            return false;
        }
        return Float.floatToIntBits(this.widthFactor) == Float.floatToIntBits(other.widthFactor);
    }
}

