/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.ImageUtilities;
import net.anwiba.commons.image.histogram.Histogram;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.thread.cancel.ICanceler;

public interface IImageContainer {
    default public BufferedImage asBufferImage() {
        try {
            return this.asBufferImage(ICanceler.DummyCanceler);
        }
        catch (CanceledException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    default public BufferedImage asBufferImage(ICanceler canceler) throws CanceledException {
        return this.asBufferImage(IMessageCollector.DummyCollector, canceler);
    }

    public BufferedImage asBufferImage(IMessageCollector var1, ICanceler var2) throws CanceledException;

    public IImageContainer crop(float var1, float var2, float var3, float var4);

    public IImageContainer crop(Rectangle var1);

    public IImageContainer fitTo(int var1, int var2);

    default public IImageContainer scale(double widthFactor, double heightFactor) {
        return this.scale(Double.valueOf(widthFactor).floatValue(), Double.valueOf(heightFactor).floatValue());
    }

    public IImageContainer scaleTo(int var1, int var2);

    public IImageContainer scale(float var1, float var2);

    public IImageContainer scale(float var1);

    public IImageContainer invert();

    public IImageContainer opacity(float var1);

    default public IImageContainer operation(IImageOperation operation) {
        return this;
    }

    public IImageContainer mapBands(int[] var1);

    public IImageContainer toGrayScale();

    public int getWidth();

    public int getHeight();

    public int getNumberOfComponents();

    public int getNumberOfBands();

    public int getColorSpaceType();

    default public boolean isScaleRecommended() {
        return false;
    }

    default public IImageMetadata getMetadata() {
        return null;
    }

    default public Number[] getValues(int x, int y) {
        try {
            return this.getValues(ICanceler.DummyCanceler, x, y);
        }
        catch (CanceledException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    default public Number[] getValues(ICanceler canceler, int x, int y) throws CanceledException {
        return this.getValues(IMessageCollector.DummyCollector, canceler, x, y);
    }

    default public Number[] getValues(IMessageCollector messageCollector, ICanceler canceler, int x, int y) throws CanceledException {
        return (Number[])Optional.of((Object)this.getValues(messageCollector, canceler, x, y, 1, 1)).accept(values -> ((Number[][])values).length > 0).convert(values -> values[0]).get();
    }

    default public Number[][] getValues(int x, int y, int width, int height) {
        try {
            return this.getValues(ICanceler.DummyCanceler, x, y, width, height);
        }
        catch (CanceledException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    default public Number[][] getValues(ICanceler canceler, int x, int y, int width, int height) throws CanceledException {
        return this.getValues(IMessageCollector.DummyCollector, canceler, x, y, width, height);
    }

    default public Number[][] getValues(IMessageCollector messageCollector, ICanceler canceler, int x, int y, int width, int height) throws CanceledException {
        BufferedImage bufferImage = this.asBufferImage(messageCollector, canceler);
        Raster raster = bufferImage.getData(new Rectangle(x, y, width, height));
        if (raster == null) {
            return null;
        }
        return ImageUtilities.getValues(raster);
    }

    default public Histogram getHistogram() {
        try {
            return this.getHistogram(IMessageCollector.DummyCollector, ICanceler.DummyCanceler);
        }
        catch (CanceledException exception) {
            throw new UnreachableCodeReachedException((Throwable)exception);
        }
    }

    public Histogram getHistogram(IMessageCollector var1, ICanceler var2) throws CanceledException;
}

