/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.utilities.IoUtilities;

public interface IImageContainerFactory {
    public static final ResourceReferenceFactory resourceReferenceFactory = new ResourceReferenceFactory();

    public IImageContainer create(IResourceReference var1) throws IOException;

    default public IImageContainer create(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            IImageContainer iImageContainer = this.create(resourceReferenceFactory.create(IoUtilities.toByteArray((InputStream)inputStream), "image", "UTF-8"));
            return iImageContainer;
        }
    }

    public IImageContainer create(BufferedImage var1);

    default public IImageContainer create(File randomAccessFile) throws IOException {
        return this.create(resourceReferenceFactory.create(randomAccessFile));
    }
}

