/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.anwiba.commons.image.IImageDirectory;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;

public interface IImageDirectoryReader {
    public static final ResourceReferenceFactory resourceReferenceFactory = new ResourceReferenceFactory();

    public IImageDirectory read(ICanceler var1, IResourceReference var2) throws CanceledException, IOException;

    default public IImageDirectory read(ICanceler canceler, InputStream inputStream) throws CanceledException, IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            IImageDirectory iImageDirectory = this.read(canceler, resourceReferenceFactory.create(IoUtilities.toByteArray((InputStream)inputStream), "image", "UTF-8"));
            return iImageDirectory;
        }
    }

    default public IImageDirectory read(ICanceler canceler, File randomAccessFile) throws CanceledException, IOException {
        return this.read(canceler, resourceReferenceFactory.create(randomAccessFile));
    }
}

