/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.codec.IImageCodecVisitor;
import net.anwiba.commons.image.codec.ImageCodec;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.utilities.FileUtilities;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;

public class ImageUtilities {
    private static ILogger logger = Logging.getLogger(ImageUtilities.class);
    private static final Dimension DEFAULT_IMAGE_SIZE = new Dimension(20, 20);
    private static final String MISSING_IMAGE_DATA = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAOCAYAAAASVl2WAAAAMElEQVR42mNgoAr4D0T/wRQOMXQFMD6KJmQBbCai6MKqAKfRRJuA1w0EfUEwHGgLAHhnTbO/SQfEAAAAAElFTkSuQmCC";

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        ColorModel colorModel = image.getColorModel();
        return new BufferedImage(colorModel, image.getRaster().createCompatibleWritableRaster(width, height), colorModel.isAlphaPremultiplied(), new Hashtable());
    }

    public static BufferedImage create(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage create(int width, int height, Color color) {
        Graphics graphic = null;
        try {
            BufferedImage image = ImageUtilities.create(width, height);
            Graphics graphics = image.getGraphics();
            graphics.setColor(color);
            graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (graphic != null) {
                graphic.dispose();
            }
        }
    }

    public static BufferedImage getEmptyImage(final Dimension size, ImageCodec imageCodec) {
        if (imageCodec == null) {
            return ImageUtilities.getTransparentImage(size);
        }
        IImageCodecVisitor<BufferedImage, RuntimeException> visitor = new IImageCodecVisitor<BufferedImage, RuntimeException>(){

            @Override
            public BufferedImage visitUnknown() {
                return ImageUtilities.getTransparentImage(size);
            }

            @Override
            public BufferedImage visitPng() {
                return ImageUtilities.getTransparentImage(size);
            }

            @Override
            public BufferedImage visitJpeg() {
                return ImageUtilities.getNonTransparentImage(size);
            }

            @Override
            public BufferedImage visitBmp() throws RuntimeException {
                return ImageUtilities.getNonTransparentImage(size);
            }

            @Override
            public BufferedImage visitTiff() throws RuntimeException {
                return ImageUtilities.getNonTransparentImage(size);
            }

            @Override
            public BufferedImage visitGif() throws RuntimeException {
                return ImageUtilities.getTransparentImage(size);
            }
        };
        return imageCodec.accept(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createOpaqueImage(BufferedImage transparentImage) {
        Graphics graphic = null;
        try {
            BufferedImage opaqueImage = new BufferedImage(transparentImage.getWidth(), transparentImage.getHeight(), 1);
            Graphics graphics = opaqueImage.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, opaqueImage.getWidth(), opaqueImage.getHeight());
            graphics.drawImage(transparentImage, 0, 0, null);
            BufferedImage bufferedImage = opaqueImage;
            return bufferedImage;
        }
        finally {
            if (graphic != null) {
                graphic.dispose();
            }
        }
    }

    public static BufferedImage getTransparentImage(Dimension size) {
        return ImageUtilities.create(size.width, size.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getNonTransparentImage(Dimension size) {
        Graphics graphic = null;
        try {
            BufferedImage image = new BufferedImage(size.width, size.height, 1);
            graphic = (Graphics2D)image.getGraphics();
            graphic.setColor(Color.WHITE);
            graphic.fillRect(0, 0, size.width, size.height);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (graphic != null) {
                graphic.dispose();
            }
        }
    }

    public static BufferedImage toOpacity(RenderingHints hints, RenderedImage source, float factor) {
        BufferedImage image = ImageUtilities.toRGBA(hints, source);
        ImageUtilities.applyOpacity(hints, image, 6, factor);
        return ImageUtilities.drawInto(hints, image, ImageUtilities.getTransparentImage(new Dimension(source.getWidth(), source.getHeight())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyOpacity(RenderingHints hints, BufferedImage image, int rule, float factor) {
        image.coerceData(true);
        Graphics2D graphics = image.createGraphics();
        try {
            graphics.setRenderingHints(hints);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
            graphics.setComposite(AlphaComposite.getInstance(rule, factor));
            graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        finally {
            graphics.dispose();
        }
    }

    public static BufferedImage toRGBA(RenderingHints hints, RenderedImage source) {
        if (ImageUtilities.isRGBA(source)) {
            return (BufferedImage)source;
        }
        return ImageUtilities.drawInto(hints, source, ImageUtilities.getTransparentImage(new Dimension(source.getWidth(), source.getHeight())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage drawInto(RenderingHints hints, RenderedImage source, BufferedImage target) {
        Graphics2D graphics = target.createGraphics();
        try {
            graphics.setRenderingHints(hints);
            graphics.drawRenderedImage(source, new AffineTransform());
            BufferedImage bufferedImage = target;
            return bufferedImage;
        }
        finally {
            graphics.dispose();
        }
    }

    private static boolean isRGBA(RenderedImage source) {
        ColorModel colorModel = source.getColorModel();
        return source instanceof BufferedImage && colorModel.hasAlpha() && colorModel.isAlphaPremultiplied() && colorModel.getColorSpace().isCS_sRGB();
    }

    public static String getMimeType(byte[] bytes, String name) {
        if (bytes != null) {
            try {
                ImageInfo info = Imaging.getImageInfo((byte[])bytes);
                if (info != null) {
                    return info.getMimeType();
                }
            }
            catch (IOException | ImageReadException e) {
                logger.warning("Unable to determine mimeType for image file " + name, e);
            }
        }
        String extension = FileUtilities.getExtension((String)name).toLowerCase();
        return "image/" + extension;
    }

    public static String convertToBase64(byte[] bytes, String mimeType) {
        if (bytes == null) {
            return MISSING_IMAGE_DATA;
        }
        String base64Image = Base64.getEncoder().encodeToString(bytes);
        return "data:" + mimeType + ";base64," + base64Image;
    }

    public static String convertToBase64(BufferedImage image, String imageCodec) {
        String string;
        block8: {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            OutputStream b64 = Base64.getEncoder().wrap(os);
            try {
                ImageIO.write((RenderedImage)image, imageCodec, b64);
                b64.flush();
                string = "data:image/" + imageCodec + ";base64," + os.toString(StandardCharsets.UTF_8.name());
                if (b64 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (b64 != null) {
                        try {
                            b64.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Unable to convert image to base64!", (Throwable)e);
                    return MISSING_IMAGE_DATA;
                }
            }
            b64.close();
        }
        return string;
    }

    public static Dimension getImageSize(byte[] bytes, String name) {
        if (bytes == null) {
            return DEFAULT_IMAGE_SIZE;
        }
        try {
            return Imaging.getImageSize((byte[])bytes);
        }
        catch (IOException | ImageReadException e) {
            logger.error("Unable to get image dimensions for file " + name, e);
            return DEFAULT_IMAGE_SIZE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon toImageIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = image.getGraphics();
        try {
            icon.paintIcon(null, graphics, 0, 0);
            ImageIcon imageIcon = new ImageIcon(image);
            return imageIcon;
        }
        finally {
            graphics.dispose();
        }
    }

    public static IOptional<Rectangle, IOException> getIntersection(IImageMetadata metadata, int x, int y, int width, int height) {
        Dimension size = new Dimension(Math.round(metadata.getWidth()), Math.round(metadata.getHeight()));
        return ImageUtilities.getIntersection(size, x, y, width, height);
    }

    public static IOptional<Rectangle, IOException> getIntersection(Dimension size, int x, int y, int width, int height) {
        Rectangle imageRectangle = new Rectangle(0, 0, size.width, size.height);
        Rectangle rectangle = new Rectangle(x, y, width, height);
        if (imageRectangle.intersects(rectangle)) {
            return Optional.of(IOException.class, (Object)imageRectangle.intersection(rectangle));
        }
        return Optional.empty(IOException.class);
    }

    public static Number[][] getValues(Raster raster) {
        int x = raster.getMinX();
        int y = raster.getMinY();
        int width = raster.getWidth();
        int height = raster.getHeight();
        Number[][] values = new Number[width * height][raster.getSampleModel().getNumBands()];
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                ImageUtilities.convertFromInt(x, y, width, height, raster, values);
                break;
            }
            case 3: {
                ImageUtilities.convertFromInt(x, y, width, height, raster, values);
                break;
            }
            case 2: {
                ImageUtilities.convertFromInt(x, y, width, height, raster, values);
                break;
            }
            case 1: {
                ImageUtilities.convertFromInt(x, y, width, height, raster, values);
                break;
            }
            case 4: {
                ImageUtilities.convertFromDouble(x, y, width, height, raster, values);
                break;
            }
            case 5: {
                ImageUtilities.convertFromDouble(x, y, width, height, raster, values);
                break;
            }
            case 32: {
                ImageUtilities.convertFromDouble(x, y, width, height, raster, values);
                break;
            }
            default: {
                ImageUtilities.convertFromDouble(x, y, width, height, raster, values);
            }
        }
        return values;
    }

    private static void convertFromInt(int x, int y, int width, int height, Raster raster, Number[][] values) {
        int[] pixel = new int[raster.getSampleModel().getNumBands()];
        int n = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                raster.getPixel(x + i, y + j, pixel);
                values[n++] = ImageUtilities.convert(pixel);
            }
        }
    }

    private static void convertFromDouble(int x, int y, int width, int height, Raster raster, Number[][] values) {
        double[] pixel = new double[raster.getSampleModel().getNumBands()];
        int n = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                raster.getPixel(x + i, y + j, pixel);
                values[n++] = ImageUtilities.convert(pixel);
            }
        }
    }

    private static Number[] convert(Object pixel) {
        if (pixel instanceof int[]) {
            int[] array = (int[])pixel;
            Number[] values = new Number[array.length];
            for (int i = 0; i < array.length; ++i) {
                values[i] = array[i];
            }
            return values;
        }
        if (pixel instanceof double[]) {
            double[] array = (double[])pixel;
            Number[] values = new Number[array.length];
            for (int i = 0; i < array.length; ++i) {
                values[i] = array[i];
            }
            return values;
        }
        throw new IllegalArgumentException();
    }

    public static List<Color> getColors(IndexColorModel colorModel) {
        if (colorModel == null || colorModel.getMapSize() == 0) {
            return List.of();
        }
        int[] colors = new int[colorModel.getMapSize()];
        boolean hasAlpha = colorModel.hasAlpha();
        colorModel.getRGBs(colors);
        return Streams.of((int[])colors).convert(i -> new Color((int)i, hasAlpha)).asList();
    }
}

