/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.anwiba.commons.image.ImageCodecVisitor;
import net.anwiba.commons.image.codec.ImageCodec;
import net.anwiba.commons.image.encoder.IEncoder;
import net.anwiba.commons.image.imagen.encoder.JpegEncoder;
import net.anwiba.commons.image.imagen.encoder.PngEncoder;
import net.anwiba.commons.reference.utilities.FileUtilities;

public class ImageWriter {
    public void write(BufferedImage image, File file) throws IOException {
        IEncoder encoder = this.getEncoder(FileUtilities.getExtension((File)file));
        this.write(image, file, encoder);
    }

    private IEncoder getEncoder(String extension) {
        ImageCodecVisitor visitor = new ImageCodecVisitor();
        return ImageCodec.getByExtension(extension).accept(visitor);
    }

    public void writeAsPng(BufferedImage image, File file) throws IOException {
        this.write(image, file, (IEncoder)new PngEncoder());
    }

    public void writeAsPng(BufferedImage image, OutputStream stream) throws IOException {
        this.write(image, stream, new PngEncoder());
    }

    private void write(BufferedImage image, OutputStream stream, PngEncoder encoder) throws IOException {
        encoder.encode(image, stream);
    }

    public void writeAsJpeg(BufferedImage image, File file) throws IOException {
        this.write(image, file, new JpegEncoder());
    }

    public void write(BufferedImage image, OutputStream outputStream, String extension) throws IOException {
        this.getEncoder(extension).encode(image, outputStream);
    }

    private void write(BufferedImage image, File file, IEncoder encoder) throws IOException, FileNotFoundException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            encoder.encode(image, fos);
        }
    }
}

