/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.apache;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.anwiba.commons.image.AbstractImageContainer;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.InvalidImageMetadata;
import net.anwiba.commons.image.apache.ApacheImageMetadata;
import net.anwiba.commons.image.apache.IByteSourceConnector;
import net.anwiba.commons.image.awt.BufferedImageContainerFactory;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.bytesource.ByteSource;

public class ApacheImageContainer
extends AbstractImageContainer
implements IImageContainer {
    private final IByteSourceConnector byteSourceConnector;

    public ApacheImageContainer(RenderingHints hints, ApacheImageMetadata imageMetadata, IByteSourceConnector byteSourceConnector, IImageMetadataAdjustor metadataAdjustor) {
        this(hints, imageMetadata, (IObjectList<IImageOperation>)new ObjectList(), byteSourceConnector, metadataAdjustor);
    }

    public ApacheImageContainer(RenderingHints hints, ApacheImageMetadata imageMetadata, IObjectList<IImageOperation> imageOperations, IByteSourceConnector byteSourceConnector, IImageMetadataAdjustor metadataAdjustor) {
        super(hints, imageMetadata, imageOperations, metadataAdjustor);
        this.byteSourceConnector = byteSourceConnector;
    }

    @Override
    protected IImageContainer adapt(RenderingHints hints, IImageMetadata metadata, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) {
        return new ApacheImageContainer(hints, (ApacheImageMetadata)metadata, operations, this.byteSourceConnector, metadataAdjustor);
    }

    @Override
    protected BufferedImage read(IMessageCollector messageCollector, ICanceler canceler, RenderingHints hints, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) throws CanceledException, IOException {
        ByteSource byteSource = this.byteSourceConnector.connect();
        IOptional<ImageParser, RuntimeException> imageParser = ApacheImageContainer.getImageParser(byteSource);
        if (imageParser.isEmpty()) {
            throw new IOException("Unsupported image format");
        }
        try {
            BufferedImage bufferedImage = ((ImageParser)imageParser.get()).getBufferedImage(byteSource, Map.of());
            IImageContainer containter = new BufferedImageContainerFactory(hints).create(bufferedImage);
            for (IImageOperation operation : operations) {
                containter.operation(operation);
            }
            return containter.asBufferImage();
        }
        catch (IOException | RuntimeException | ImageReadException exception) {
            throw new IOException("Unsupported image format");
        }
    }

    @Override
    protected IImageMetadata read(ICanceler canceler, RenderingHints hints) throws CanceledException, IOException {
        ByteSource byteSource = this.byteSourceConnector.connect();
        IOptional<ImageParser, RuntimeException> imageParser = ApacheImageContainer.getImageParser(byteSource);
        if (imageParser.isEmpty()) {
            return new InvalidImageMetadata(Message.error((String)"Unsupported image format").throwable((Throwable)new UnsupportedOperationException("Unsupported image format")).build());
        }
        try {
            ImageParser parser = (ImageParser)imageParser.get();
            ImageInfo imageInfo = parser.getImageInfo(byteSource);
            return new ApacheImageMetadata(imageInfo.getWidth(), imageInfo.getHeight(), this.guessNumberOfComponents(imageInfo), this.guessNumberOfBands(imageInfo), this.guessColorSpaceType(imageInfo), this.guessDataType(imageInfo), this.guessTransparency(imageInfo), false);
        }
        catch (IOException | RuntimeException | ImageReadException exception) {
            return new InvalidImageMetadata(Message.error((Throwable)exception).build());
        }
    }

    private int guessNumberOfComponents(ImageInfo imageInfo) {
        ImageInfo.ColorType colorType = imageInfo.getColorType();
        return Set.of(ImageInfo.ColorType.BW, ImageInfo.ColorType.GRAYSCALE).contains(colorType) ? 1 : 3;
    }

    private int guessNumberOfBands(ImageInfo imageInfo) {
        return this.guessNumberOfComponents(imageInfo) + (imageInfo.isTransparent() ? 1 : 0);
    }

    private int guessColorSpaceType(ImageInfo imageInfo) {
        ImageInfo.ColorType colorType = imageInfo.getColorType();
        return switch (colorType) {
            default -> throw new IncompatibleClassChangeError();
            case ImageInfo.ColorType.BW -> 6;
            case ImageInfo.ColorType.CMYK -> 9;
            case ImageInfo.ColorType.GRAYSCALE -> 6;
            case ImageInfo.ColorType.RGB -> 5;
            case ImageInfo.ColorType.YCC -> 3;
            case ImageInfo.ColorType.YCCK -> 3;
            case ImageInfo.ColorType.YCbCr -> 3;
            case ImageInfo.ColorType.OTHER -> 5;
            case ImageInfo.ColorType.UNKNOWN -> 5;
        };
    }

    private int guessTransparency(ImageInfo imageInfo) {
        return imageInfo.isTransparent() ? 3 : 0;
    }

    private int guessDataType(ImageInfo imageInfo) {
        return 0;
    }

    private static IOptional<ImageParser, RuntimeException> getImageParser(ByteSource byteSource) throws IOException {
        try {
            return ApacheImageContainer.getImageParser(Imaging.guessFormat((ByteSource)byteSource));
        }
        catch (ImageReadException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    private static IOptional<ImageParser, RuntimeException> getImageParser(ImageFormat ... formats) {
        for (ImageFormat format : formats) {
            ImageParser[] imageParsers;
            for (ImageParser imageParser : imageParsers = ImageParser.getAllImageParsers()) {
                if (!imageParser.canAcceptType(format)) continue;
                return Optional.of((Object)imageParser);
            }
        }
        return Optional.empty();
    }
}

