/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.apache;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.anwiba.commons.image.IImageDirectory;
import net.anwiba.commons.image.IImageDirectoryItem;
import net.anwiba.commons.image.apache.ByteSourceConnectorFactory;
import net.anwiba.commons.image.apache.IByteSourceConnector;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.utilities.FileUtilities;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;

public class ApacheImageDirectoryReader {
    private final ByteSourceConnectorFactory inputStreamConnectorFactory;

    public ApacheImageDirectoryReader(IResourceReferenceHandler resourceReferenceHandler) {
        this.inputStreamConnectorFactory = new ByteSourceConnectorFactory(resourceReferenceHandler);
    }

    public IImageDirectory read(ICanceler canceler, IResourceReference resourceReference) throws CanceledException, IOException {
        IByteSourceConnector connector = this.inputStreamConnectorFactory.create(resourceReference);
        ByteSource byteSource = connector.connect();
        ImageParser imageParser = (ImageParser)ApacheImageDirectoryReader.getImageParser(byteSource).get();
        try {
            ImageMetadata metadata = imageParser.getMetadata(byteSource);
            final List items = new LinkedHashSet(metadata.getItems()).stream().map(this::convert).filter(i -> i != null).collect(Collectors.toList());
            return new IImageDirectory(){

                @Override
                public List<IImageDirectoryItem> getItems() {
                    return items;
                }
            };
        }
        catch (ImageReadException exception) {
            return new IImageDirectory(){};
        }
    }

    public boolean isSupported(IResourceReference resourceReference) {
        IByteSourceConnector connector = this.inputStreamConnectorFactory.create(resourceReference);
        try {
            ByteSource byteSource = connector.connect();
            return ApacheImageDirectoryReader.getImageParser(byteSource).isAccepted();
        }
        catch (IOException exception) {
            return false;
        }
    }

    private static IOptional<ImageParser, RuntimeException> getImageParser(ByteSource byteSource) throws IOException {
        try {
            return ApacheImageDirectoryReader.getImageParser(Imaging.guessFormat((ByteSource)byteSource));
        }
        catch (ImageReadException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    private static IOptional<ImageParser, RuntimeException> getImageParser(ImageFormat ... formats) {
        Set<ImageFormats> supportedTypes = Set.of(ImageFormats.TIFF, ImageFormats.JBIG2, ImageFormats.JPEG);
        for (ImageFormat format : formats) {
            ImageParser[] imageParsers;
            if (!supportedTypes.contains(format)) continue;
            for (ImageParser imageParser : imageParsers = ImageParser.getAllImageParsers()) {
                if (!imageParser.canAcceptType(format)) continue;
                return Optional.of((Object)imageParser);
            }
        }
        return Optional.empty();
    }

    private static ImageFormat guessFormat(String fileName) {
        String lowerCase = fileName.toLowerCase();
        return (ImageFormat)Streams.of((Object[])ImageFormats.values()).first(f -> Objects.equals(f.getExtension().toLowerCase(), FileUtilities.getExtension((String)lowerCase))).get();
    }

    private IImageDirectoryItem convert(ImageMetadata.ImageMetadataItem item) {
        if (item instanceof TiffImageMetadata.TiffMetadataItem) {
            final TiffImageMetadata.TiffMetadataItem tiffMetadataItem = (TiffImageMetadata.TiffMetadataItem)item;
            return new IImageDirectoryItem(){
                private int tag = -1;
                private String name = null;
                private String text = null;

                @Override
                public int getTag() {
                    if (this.tag == -1) {
                        this.tag = tiffMetadataItem.getTiffField().getTag();
                    }
                    return this.tag;
                }

                @Override
                public String getName() {
                    if (this.name == null) {
                        this.name = tiffMetadataItem.getKeyword();
                    }
                    return this.name;
                }

                @Override
                public String getValue() {
                    if (this.text == null) {
                        this.text = tiffMetadataItem.getText();
                    }
                    return this.text;
                }
            };
        }
        return null;
    }
}

