/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.awt;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.awt.BufferedImageMetadata;
import net.anwiba.commons.image.awt.BufferedImageMetadataAdjustor;
import net.anwiba.commons.image.awt.IBufferedImageOperator;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.image.operation.ImageCropOperation;
import net.anwiba.commons.image.operation.ImageInvertOperation;
import net.anwiba.commons.image.operation.ImageMapBandsOperation;
import net.anwiba.commons.image.operation.ImageOpacityOperation;
import net.anwiba.commons.image.operation.ImageScaleOperation;
import net.anwiba.commons.image.operation.ImageToGrayScaleOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.thread.cancel.ICanceler;

public class BufferedImageOperatorFactory {
    private static IBufferedImageOperator doNothingOperation = new IBufferedImageOperator(){

        @Override
        public BufferedImage execute(ICanceler canceler, BufferedImage source) {
            return source;
        }
    };
    private final IImageMetadataAdjustor metadataAdjustor;

    public BufferedImageOperatorFactory() {
        this(new BufferedImageMetadataAdjustor());
    }

    public BufferedImageOperatorFactory(IImageMetadataAdjustor metadataAdjustor) {
        this.metadataAdjustor = metadataAdjustor;
    }

    public ObjectPair<IBufferedImageOperator, BufferedImageMetadata> create(BufferedImageMetadata metadata, IImageOperation operation, RenderingHints hints) {
        if (operation instanceof ImageScaleOperation) {
            ImageScaleOperation o = (ImageScaleOperation)operation;
            return ObjectPair.of((Object)BufferedImageOperatorFactory.createImageScaleOperation(hints, o), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageCropOperation) {
            ImageCropOperation o = (ImageCropOperation)operation;
            return ObjectPair.of((Object)this.createImageCropOperation(o), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageMapBandsOperation) {
            ImageMapBandsOperation o = (ImageMapBandsOperation)operation;
            return ObjectPair.of((Object)BufferedImageOperatorFactory.createImageMapBandsOperation(metadata, hints, o), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageOpacityOperation) {
            ImageOpacityOperation o = (ImageOpacityOperation)operation;
            if (o.getFactor() >= 1.0f) {
                return ObjectPair.of((Object)doNothingOperation, (Object)metadata);
            }
            return ObjectPair.of((Object)BufferedImageOperatorFactory.createImageOpacityOperation(metadata, hints, o), (Object)this.adapt(metadata, operation));
        }
        if (operation instanceof ImageInvertOperation) {
            return ObjectPair.of((Object)BufferedImageOperatorFactory.createImageInvertOperation(metadata, hints), (Object)metadata);
        }
        if (operation instanceof ImageToGrayScaleOperation) {
            return ObjectPair.of((Object)BufferedImageOperatorFactory.createImageToGrayScaleOperation(hints), (Object)this.adapt(metadata, operation));
        }
        return ObjectPair.of((Object)doNothingOperation, (Object)metadata);
    }

    private BufferedImageMetadata adapt(IImageMetadata metadata, IImageOperation operation) {
        return (BufferedImageMetadata)this.metadataAdjustor.adjust(metadata, operation);
    }

    public static IBufferedImageOperator createImageScaleOperation(RenderingHints hints, ImageScaleOperation o) {
        return new BufferedImageOpOperator(new AffineTransformOp(AffineTransform.getScaleInstance(o.getWidthFactor(), o.getHeightFactor()), hints));
    }

    private IBufferedImageOperator createImageCropOperation(ImageCropOperation o) {
        return (canceler, source) -> {
            int x = Math.round(o.getX());
            int y = Math.round(o.getY());
            int width = Math.round(o.getWidth());
            int height = Math.round(o.getHeight());
            return source.getSubimage(x, y, x + width > source.getWidth() ? source.getWidth() - x : width, y + height > source.getHeight() ? source.getHeight() - y : height);
        };
    }

    public static IBufferedImageOperator createImageMapBandsOperation(IImageMetadata metadata, RenderingHints hints, ImageMapBandsOperation o) {
        final int[] mappings = o.getBandMapping();
        LookupTable lookupTable = new LookupTable(0, metadata.getNumberOfBands()){

            @Override
            public int[] lookupPixel(int[] src, int[] dest) {
                for (int i = 0; i < dest.length; ++i) {
                    dest[i] = i < mappings.length ? src[mappings[i]] : 255;
                }
                return dest;
            }
        };
        return new BufferedImageOpOperator(new LookupOp(lookupTable, hints));
    }

    public static IBufferedImageOperator createImageOpacityOperation(IImageMetadata metadata, final RenderingHints hints, ImageOpacityOperation o) {
        final float factor = o.getFactor();
        if (metadata.getNumberOfBands() == 1 || metadata.getNumberOfBands() == 3) {
            return new IBufferedImageOperator(){

                @Override
                public BufferedImage execute(ICanceler canceler, BufferedImage source) {
                    BufferedImage image = new ColorConvertOp(hints).filter(source, new BufferedImage(source.getWidth(), source.getHeight(), 2));
                    BufferedImage result = new LookupOp(new LookupTable(0, 4){

                        @Override
                        public int[] lookupPixel(int[] src, int[] dest) {
                            dest[0] = src[0];
                            dest[1] = src[1];
                            dest[2] = src[2];
                            dest[3] = Math.round((float)src[3] * factor);
                            return dest;
                        }
                    }, hints).filter(image, null);
                    return result;
                }
            };
        }
        LookupTable lookupTable = BufferedImageOperatorFactory.createColorOpacityLookupTable(metadata, factor);
        return new BufferedImageOpOperator(new LookupOp(lookupTable, hints));
    }

    private static LookupTable createColorOpacityLookupTable(IImageMetadata metadata, final float factor) {
        return new LookupTable(0, metadata.getNumberOfBands()){

            @Override
            public int[] lookupPixel(int[] src, int[] dest) {
                for (int i = 0; i < dest.length - 1; ++i) {
                    dest[i] = src[i];
                }
                dest[dest.length - 1] = Math.round((float)src[dest.length - 1] * factor);
                return dest;
            }
        };
    }

    public static IBufferedImageOperator createImageInvertOperation(IImageMetadata metadata, RenderingHints hints) {
        LookupTable lookupTable = BufferedImageOperatorFactory.createColorInvertLookupTable(metadata);
        return new BufferedImageOpOperator(new LookupOp(lookupTable, hints));
    }

    private static LookupTable createColorInvertLookupTable(IImageMetadata metadata) {
        if (6 == metadata.getColorSpaceType() && metadata.getNumberOfBands() == 1) {
            return new LookupTable(0, metadata.getNumberOfBands()){

                @Override
                public int[] lookupPixel(int[] src, int[] dest) {
                    dest[0] = 255 - src[0];
                    return dest;
                }
            };
        }
        if (6 == metadata.getColorSpaceType() && metadata.getNumberOfBands() == 2) {
            return new LookupTable(0, metadata.getNumberOfBands()){

                @Override
                public int[] lookupPixel(int[] src, int[] dest) {
                    dest[0] = 255 - src[0];
                    dest[1] = src[1];
                    return dest;
                }
            };
        }
        if (metadata.getNumberOfColorComponents() == 3) {
            return new LookupTable(0, metadata.getNumberOfBands()){

                @Override
                public int[] lookupPixel(int[] src, int[] dest) {
                    dest[0] = 255 - src[0];
                    dest[1] = 255 - src[1];
                    dest[2] = 255 - src[2];
                    return dest;
                }
            };
        }
        if (metadata.getNumberOfColorComponents() == 4) {
            return new LookupTable(0, metadata.getNumberOfBands()){

                @Override
                public int[] lookupPixel(int[] src, int[] dest) {
                    dest[0] = 255 - src[0];
                    dest[1] = 255 - src[1];
                    dest[2] = 255 - src[2];
                    dest[3] = src[3];
                    return dest;
                }
            };
        }
        return new LookupTable(0, metadata.getNumberOfBands()){

            @Override
            public int[] lookupPixel(int[] src, int[] dest) {
                for (int i = 0; i < dest.length; ++i) {
                    dest[i] = i == 3 ? src[i] : 255 - src[i];
                }
                return dest;
            }
        };
    }

    public static IBufferedImageOperator createImageToGrayScaleOperation(RenderingHints hints) {
        return new BufferedImageOpOperator(new ColorConvertOp(ColorSpace.getInstance(1003), hints));
    }

    IBufferedImageOperator create(BufferedImageMetadata metadata, IObjectList<IImageOperation> imageOperations, RenderingHints hints) {
        if (imageOperations.isEmpty()) {
            return new AggregatedBufferedImageOperator((IObjectList<IBufferedImageOperator>)new ObjectList());
        }
        IOptional<ImageScaleOperation, RuntimeException> scaleOperation = ImageScaleOperation.aggregate(imageOperations);
        IOptional<ImageCropOperation, RuntimeException> cropOperation = ImageCropOperation.aggregate(imageOperations);
        ObjectList operations = new ObjectList();
        if (cropOperation.isAccepted()) {
            operations.add((Object[])new IImageOperation[]{(IImageOperation)cropOperation.get()});
        }
        if (scaleOperation.accept(s -> s.getWidthFactor() < 1.0f && s.getHeightFactor() < 1.0f).isAccepted()) {
            operations.add((Object[])new IImageOperation[]{(IImageOperation)scaleOperation.get()});
        }
        for (IImageOperation operation : imageOperations) {
            if (operation instanceof ImageScaleOperation || operation instanceof ImageCropOperation || operation instanceof ImageMapBandsOperation && ((ImageMapBandsOperation)operation).getMappingSize() == 0) continue;
            operations.add((Object[])new IImageOperation[]{operation});
        }
        if (scaleOperation.accept(s -> s.getWidthFactor() > 1.0f || s.getHeightFactor() > 1.0f).isAccepted()) {
            operations.add((Object[])new IImageOperation[]{(IImageOperation)scaleOperation.get()});
        }
        ObjectList collection = new ObjectList();
        BufferedImageMetadata imageMetadata = metadata;
        for (IImageOperation operation : operations) {
            ObjectPair<IBufferedImageOperator, BufferedImageMetadata> pair = this.create(imageMetadata, operation, hints);
            collection.add((Object[])new IBufferedImageOperator[]{(IBufferedImageOperator)pair.getFirstObject()});
            imageMetadata = (BufferedImageMetadata)pair.getSecondObject();
        }
        return new AggregatedBufferedImageOperator((IObjectList<IBufferedImageOperator>)collection);
    }

    private static final class BufferedImageOpOperator
    implements IBufferedImageOperator {
        private final IBufferedImageFactory bufferedImageFactory;
        private final BufferedImageOp bufferedImageOp;

        public BufferedImageOpOperator(BufferedImageOp bufferedImageOp) {
            this(b -> null, bufferedImageOp);
        }

        public BufferedImageOpOperator(IBufferedImageFactory bufferedImageFactory, BufferedImageOp bufferedImageOp) {
            this.bufferedImageFactory = bufferedImageFactory;
            this.bufferedImageOp = bufferedImageOp;
        }

        @Override
        public BufferedImage execute(ICanceler canceler, BufferedImage source) {
            return this.bufferedImageOp.filter(source, this.bufferedImageFactory.create(source));
        }
    }

    private static final class AggregatedBufferedImageOperator
    implements IBufferedImageOperator {
        private final IObjectList<IBufferedImageOperator> collection;

        public AggregatedBufferedImageOperator(IObjectList<IBufferedImageOperator> collection) {
            this.collection = collection;
        }

        @Override
        public BufferedImage execute(ICanceler canceler, BufferedImage source) throws CanceledException {
            return (BufferedImage)Streams.of(CanceledException.class, this.collection).aggregate((Object)source, (s, o) -> {
                if (canceler.isCanceled()) {
                    return null;
                }
                return s == null ? null : o.execute(canceler, (BufferedImage)s);
            }).get();
        }
    }

    private static interface IBufferedImageFactory {
        public BufferedImage create(BufferedImage var1);
    }
}

