/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.codec;

import net.anwiba.commons.image.codec.IImageCodecVisitor;
import net.anwiba.commons.utilities.string.StringUtilities;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ImageCodec {
    BMP(false, new String[]{"bmp"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitBmp();
        }
    }
    ,
    GIF(true, new String[]{"gif"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitGif();
        }
    }
    ,
    JPEG(false, new String[]{"jpg", "jpeg"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitJpeg();
        }
    }
    ,
    PNG(true, new String[]{"png"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitPng();
        }
    }
    ,
    TIFF(false, new String[]{"tif", "tiff"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitTiff();
        }
    }
    ,
    UNKNOWN(true, new String[0]){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitUnknown();
        }
    };

    private final String[] extensions;
    private final boolean isTransparentSupported;

    private ImageCodec(boolean isTransparentSupported, String ... extension) {
        this.isTransparentSupported = isTransparentSupported;
        this.extensions = extension;
    }

    public static ImageCodec getByExtension(String extension) {
        for (ImageCodec imageCodec : ImageCodec.values()) {
            if (!StringUtilities.containsIgnoreCase((String)extension, (String[])imageCodec.extensions)) continue;
            return imageCodec;
        }
        return UNKNOWN;
    }

    public abstract <T, E extends Exception> T accept(IImageCodecVisitor<T, E> var1) throws E;

    public String getName() {
        return this.name();
    }

    public boolean isTransparentSupported() {
        return this.isTransparentSupported;
    }

    public String getExtension() {
        if (this.extensions.length == 0) {
            return "*";
        }
        return this.extensions[0];
    }

    public String[] getExtensions() {
        return this.extensions;
    }
}

