/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.generator;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.anwiba.commons.image.generator.IImageGenerator;

public class ImageGenerator
implements IImageGenerator {
    private final Random random;
    private final int minimumImageEdgeSize;
    private final int maximumImageEdgeSize;

    public static BufferedImage of(int width, int height, long seed) {
        return new ImageGenerator(seed, width, height).createImage(width, height);
    }

    public ImageGenerator(long seed, int minimumImageEdgeSize, int maximumImageEdgeSize) {
        this.minimumImageEdgeSize = minimumImageEdgeSize;
        this.maximumImageEdgeSize = maximumImageEdgeSize;
        if (seed == -1L) {
            this.random = new Random();
            return;
        }
        this.random = new Random(seed);
    }

    @Override
    public BufferedImage createImage() {
        return this.createImage(this.randomSize(), this.randomSize());
    }

    private int randomSize() {
        return this.random.nextInt(this.maximumImageEdgeSize - this.minimumImageEdgeSize) + this.minimumImageEdgeSize;
    }

    @Override
    public BufferedImage createImage(int width, int height) {
        int imageType = 6;
        return this.createImage(width, height, 6);
    }

    @Override
    public BufferedImage createImage(int width, int height, int imageType) {
        BufferedImage image = new BufferedImage(width, height, imageType);
        this.paint((Graphics2D)image.getGraphics(), 0.0, 0.0, width, height);
        return image;
    }

    private void paint(Graphics2D g2d, double x, double y, double width, double height) {
        int i;
        for (i = 0; i < 1000; ++i) {
            this.fillRandomCircle(g2d, x, y, width, height);
        }
        for (i = 0; i < 100; ++i) {
            this.drawRandomString(g2d, x, y, width, height);
        }
    }

    private void drawRandomString(Graphics2D g2d, double x, double y, double width, double height) {
        this.setRandomColor(g2d);
        this.setRandomFont(g2d);
        double theta = this.random.nextDouble() * 2.0 * Math.PI;
        AffineTransform originalTransform = (AffineTransform)g2d.getTransform().clone();
        g2d.translate(x + width / 2.0, y + height / 2.0);
        g2d.rotate(theta);
        float x0 = (float)(this.random.nextDouble() * width / 2.0);
        int value = (int)(this.random.nextDouble() * 2.147483647E9);
        g2d.drawString(String.valueOf(value), x0, 0.0f);
        g2d.setTransform(originalTransform);
    }

    private void setRandomFont(Graphics2D g2d) {
        float fontSize = (float)(this.random.nextDouble() * 36.0);
        g2d.setFont(g2d.getFont().deriveFont(fontSize));
    }

    private void fillRandomCircle(Graphics2D g2d, double x, double y, double width, double height) {
        this.setRandomColor(g2d);
        double x1 = x + this.random.nextDouble() * width;
        double x2 = x + this.random.nextDouble() * width;
        double y1 = y + this.random.nextDouble() * height;
        double y2 = y + this.random.nextDouble() * height;
        double minX = Math.min(x1, x2);
        double maxX = Math.max(x1, x2);
        double minY = Math.min(y1, y2);
        double maxY = Math.max(y1, y2);
        g2d.fill(new Ellipse2D.Double(minX, minY, maxX - minX, maxY - minY));
    }

    private void setRandomColor(Graphics2D g2d) {
        float r = (float)this.random.nextDouble();
        float g = (float)this.random.nextDouble();
        float b = (float)this.random.nextDouble();
        float a = (float)this.random.nextDouble();
        g2d.setColor(new Color(r, g, b, a));
    }
}

