/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.histogram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.image.histogram.HistogramBuilder;
import net.anwiba.commons.image.histogram.HistorgramBand;
import net.anwiba.commons.image.histogram.HistorgramBandEntry;
import net.anwiba.commons.lang.stream.Streams;

public class Histogram
implements Iterable<HistorgramBand> {
    private final double minimum;
    private final double maximum;
    private final double maximumPercent;
    private final Map<Integer, HistorgramBand> historgramBands;

    public Histogram(double minimum, double maximum, double maximumPercent, Map<Integer, HistorgramBand> historgramBands) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.maximumPercent = maximumPercent;
        this.historgramBands = historgramBands;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMaximumPercent() {
        return this.maximumPercent;
    }

    public List<Integer> getBandNumbers() {
        ArrayList<Integer> numbers = new ArrayList<Integer>(this.historgramBands.keySet());
        Collections.sort(numbers);
        return numbers;
    }

    public int getNumberOfBands() {
        return this.historgramBands.size();
    }

    public HistorgramBand getBand(Integer number) {
        return this.historgramBands.get(number);
    }

    @Override
    public Iterator<HistorgramBand> iterator() {
        return this.historgramBands.values().iterator();
    }

    public static Histogram merge(List<Histogram> histograms) {
        if (histograms.size() == 1) {
            return histograms.get(0);
        }
        HistogramBuilder builder = new HistogramBuilder();
        List<Integer> bandNumbers = Histogram.bandNumbers(histograms);
        for (Integer bandNumber : bandNumbers) {
            List<HistorgramBand> historgramBands = Histogram.historgramBands(bandNumber, histograms);
            HashMap<Interval, Long> countsByInterval = new HashMap<Interval, Long>();
            for (HistorgramBand historgramBand : historgramBands) {
                Collection<HistorgramBandEntry> entries = historgramBand.getEntries();
                for (HistorgramBandEntry entry : entries) {
                    Interval interval = new Interval(entry.getMinimum(), entry.getMaximum());
                    if (countsByInterval.containsKey(interval)) {
                        countsByInterval.put(interval, (Long)countsByInterval.get(interval) + entry.getCount());
                        continue;
                    }
                    countsByInterval.put(interval, entry.getCount());
                }
            }
            ArrayList entries = new ArrayList(countsByInterval.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<Interval, Long>>(){

                @Override
                public int compare(Map.Entry<Interval, Long> o1, Map.Entry<Interval, Long> o2) {
                    return Double.valueOf(o1.getKey().minimum()).compareTo(o2.getKey().minimum());
                }
            });
            long sumOfCounts = (Long)Streams.of(historgramBands).aggregate((Object)0L, (o, band) -> o + band.getSumOfCounts()).getOr(() -> 0L);
            double factor = 1.0 / (double)sumOfCounts;
            for (Map.Entry entry : entries) {
                long count = (Long)entry.getValue();
                builder.add(bandNumber, ((Interval)entry.getKey()).minimum(), ((Interval)entry.getKey()).maximum(), count, (double)count * factor);
            }
        }
        return builder.build();
    }

    private static List<HistorgramBand> historgramBands(Integer bandNumber, List<Histogram> histograms) {
        return Streams.of(histograms).convert(histogram -> histogram.getBand(bandNumber)).asList();
    }

    private static List<Integer> bandNumbers(List<Histogram> histograms) {
        LinkedHashSet numbers = new LinkedHashSet();
        histograms.forEach(histogram -> numbers.addAll(histogram.getBandNumbers()));
        ArrayList<Integer> result = new ArrayList<Integer>(numbers);
        Collections.sort(result);
        return result;
    }

    record Interval(double minimum, double maximum) {
    }
}

