/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.histogram;

import java.util.HashMap;
import net.anwiba.commons.image.histogram.Histogram;
import net.anwiba.commons.image.histogram.HistorgramBand;
import net.anwiba.commons.image.histogram.HistorgramBandBuilder;

public class HistogramBuilder {
    private double minimum = Double.NaN;
    private double maximum = Double.NaN;
    private double maximumPercent = Double.NaN;
    private final HashMap<Integer, HistorgramBandBuilder> historgramBandBuilders = new HashMap();

    public void add(Integer band, double minimum, double maximum, long count, double percent) {
        this.minimum = Double.isNaN(this.minimum) ? minimum : Math.min(this.minimum, minimum);
        this.maximum = Double.isNaN(this.maximum) ? maximum : Math.max(this.maximum, maximum);
        this.maximumPercent = Double.isNaN(this.maximumPercent) ? percent : Math.max(this.maximumPercent, percent);
        this.historgramBandBuilders.putIfAbsent(band, new HistorgramBandBuilder(band));
        HistorgramBandBuilder builder = this.historgramBandBuilders.get(band);
        builder.add(minimum, maximum, count, percent);
    }

    public Histogram build() {
        HashMap<Integer, HistorgramBand> historgramBands = new HashMap<Integer, HistorgramBand>();
        for (HistorgramBandBuilder builder : this.historgramBandBuilders.values()) {
            HistorgramBand band = builder.build();
            historgramBands.put(band.getNumber(), band);
        }
        return new Histogram(Double.isNaN(this.minimum) ? 0.0 : this.minimum, Double.isNaN(this.maximum) ? 255.0 : this.maximum, Double.isNaN(this.maximumPercent) ? 1.0 : this.maximumPercent, historgramBands);
    }
}

