/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.histogram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.anwiba.commons.image.histogram.HistorgramBandEntry;
import net.anwiba.commons.lang.stream.Streams;

public class HistorgramBand
implements Iterable<HistorgramBandEntry> {
    private final Integer number;
    private final Collection<HistorgramBandEntry> entries;
    private final double minimum;
    private final double maximum;
    private final double maximumPercent;

    public HistorgramBand(Integer number, double minimum, double maximum, double maximumPercent, Collection<HistorgramBandEntry> entries) {
        this.number = number;
        this.minimum = minimum;
        this.maximum = maximum;
        this.maximumPercent = maximumPercent;
        this.entries = new ArrayList<HistorgramBandEntry>(entries);
    }

    public Integer getNumber() {
        return this.number;
    }

    public Collection<HistorgramBandEntry> getEntries() {
        return this.entries;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMaximumPercent() {
        return this.maximumPercent;
    }

    @Override
    public Iterator<HistorgramBandEntry> iterator() {
        return this.entries.iterator();
    }

    public double getPercent(double value) {
        for (HistorgramBandEntry entry : this.entries) {
            if (!(entry.getMinimum() <= value) || !(entry.getMaximum() > value)) continue;
            return entry.getPercent();
        }
        return Double.NaN;
    }

    public Long getSumOfCounts() {
        return (Long)Streams.of(this.entries).aggregate((Object)0L, (o, entry) -> o + entry.getCount()).get();
    }
}

