/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.histogram;

import java.util.SortedSet;
import java.util.TreeSet;
import net.anwiba.commons.image.histogram.HistorgramBand;
import net.anwiba.commons.image.histogram.HistorgramBandEntry;

public class HistorgramBandBuilder {
    private double minimum = Double.NaN;
    private double maximum = Double.NaN;
    private double maximumPercent = Double.NaN;
    private final Integer band;
    SortedSet<HistorgramBandEntry> entries = new TreeSet<HistorgramBandEntry>();

    public HistorgramBandBuilder(Integer band) {
        this.band = band;
    }

    public void add(double minimum, double maximum, long count, double percent) {
        this.minimum = Double.isNaN(this.minimum) ? minimum : Math.min(this.minimum, minimum);
        this.maximum = Double.isNaN(this.maximum) ? maximum : Math.max(this.maximum, maximum);
        this.maximumPercent = Double.isNaN(this.maximumPercent) ? percent : Math.max(this.maximum, percent);
        this.entries.add(new HistorgramBandEntry(minimum, maximum, count, percent));
    }

    public HistorgramBand build() {
        return new HistorgramBand(this.band, this.minimum, this.maximum, this.maximumPercent, this.entries);
    }
}

