/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.histogram;

public class HistorgramBandEntry
implements Comparable<HistorgramBandEntry> {
    private final double minimum;
    private final double maximum;
    private final long count;
    private final double percent;
    private final double mean;

    public HistorgramBandEntry(double minimum, double maximum, long count, double percent) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.mean = (this.minimum + this.maximum) / 2.0;
        this.count = count;
        this.percent = percent;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public long getCount() {
        return this.count;
    }

    public double getPercent() {
        return this.percent;
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public int compareTo(HistorgramBandEntry other) {
        return Double.compare(this.mean, other.mean);
    }
}

