/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imageio;

import java.awt.RenderingHints;
import java.util.function.Function;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import net.anwiba.commons.lang.collection.IObjectList;

public interface IImageIoImageContainerSettings {
    public static final int IMAGE_IO_IMAGE_CONTAINER_SETTINGS = 0;
    public static final RenderingHints.Key KEY_IMAGE_IO_IMAGE_CONTAINER_SETTINGS = new RenderingKey(0, IImageIoImageContainerSettings.class);

    default public boolean isEnabled() {
        return true;
    }

    public IImageIoImageContainerSettings adaptImageTypeSelection(Function<IObjectList<ImageTypeSpecifier>, ImageTypeSpecifier> var1);

    public IImageIoImageContainerSettings adaptReaderSelection(Function<IObjectList<ImageReader>, ImageReader> var1);

    public ImageReader getImageReader(IObjectList<ImageReader> var1);

    public ImageTypeSpecifier getImageTypeSpecifier(IObjectList<ImageTypeSpecifier> var1);

    public static IImageIoImageContainerSettings getSettings(RenderingHints hints) {
        return hints.getOrDefault(KEY_IMAGE_IO_IMAGE_CONTAINER_SETTINGS, IImageIoImageContainerSettings.of());
    }

    public static IImageIoImageContainerSettings of() {
        return new ImageIoImageContainerSettings();
    }

    public static class ImageIoImageContainerSettings
    implements IImageIoImageContainerSettings {
        Function<IObjectList<ImageReader>, ImageReader> readerSelection;
        Function<IObjectList<ImageTypeSpecifier>, ImageTypeSpecifier> imageTypeSelection;

        private ImageIoImageContainerSettings() {
            this(r -> (ImageReader)r.stream().first().get(), t -> (ImageTypeSpecifier)t.stream().first().get());
        }

        private ImageIoImageContainerSettings(Function<IObjectList<ImageReader>, ImageReader> readerSelection, Function<IObjectList<ImageTypeSpecifier>, ImageTypeSpecifier> imageTypeSelection) {
            this.readerSelection = readerSelection;
            this.imageTypeSelection = imageTypeSelection;
        }

        @Override
        public ImageReader getImageReader(IObjectList<ImageReader> imageReaders) {
            return this.readerSelection.apply(imageReaders);
        }

        @Override
        public ImageTypeSpecifier getImageTypeSpecifier(IObjectList<ImageTypeSpecifier> imageTypeSpecifiers) {
            return this.imageTypeSelection.apply(imageTypeSpecifiers);
        }

        @Override
        public ImageIoImageContainerSettings adaptReaderSelection(Function<IObjectList<ImageReader>, ImageReader> readerSelection) {
            return new ImageIoImageContainerSettings(readerSelection, this.imageTypeSelection);
        }

        @Override
        public ImageIoImageContainerSettings adaptImageTypeSelection(Function<IObjectList<ImageTypeSpecifier>, ImageTypeSpecifier> imageTypeSelection) {
            return new ImageIoImageContainerSettings(this.readerSelection, imageTypeSelection);
        }
    }

    public static class RenderingKey
    extends RenderingHints.Key {
        private final Class objectClass;

        RenderingKey(int privateKey, Class objectClass) {
            super(privateKey);
            this.objectClass = objectClass;
        }

        @Override
        public boolean isCompatibleValue(Object val) {
            return this.objectClass.isInstance(val);
        }
    }
}

