/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imageio;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageContainerSettings;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.ImageUtilities;
import net.anwiba.commons.image.awt.BufferedImageContainerFactory;
import net.anwiba.commons.image.imageio.IImageInputStreamConnector;
import net.anwiba.commons.image.imageio.IImageIoImageContainerSettings;
import net.anwiba.commons.image.imageio.ImageIoImageContainer;
import net.anwiba.commons.image.imageio.ImageIoImageMetadata;
import net.anwiba.commons.image.imageio.ImageIoImageMetadataAdjustor;
import net.anwiba.commons.image.imageio.SeekableImageInputStream;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.reference.FileResourceReference;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.MemoryResourceReference;
import net.anwiba.commons.reference.PathResourceReference;
import net.anwiba.commons.reference.URIResourceReference;
import net.anwiba.commons.reference.URLResourceReference;
import net.anwiba.commons.reference.UniformResourceLocatorReference;
import net.anwiba.commons.reference.url.IUrl;
import net.anwiba.commons.reference.url.builder.UrlBuilder;
import net.anwiba.commons.reference.url.parser.UrlParser;
import org.eclipse.imagen.media.codec.ByteArraySeekableStream;
import org.eclipse.imagen.media.codec.SeekableStream;

public class ImageIoImageContainerFactory {
    private static ILogger logger = Logging.getLogger(ImageIoImageContainerFactory.class);
    private final IImageMetadataAdjustor metadataAdjustor = new ImageIoImageMetadataAdjustor();
    private final RenderingHints hints;
    final BufferedImageContainerFactory bufferedImageContainerFactory;
    private final IResourceReferenceHandler resourceReferenceHandler;

    public ImageIoImageContainerFactory(RenderingHints hints, IResourceReferenceHandler resourceReferenceHandler) {
        this.hints = hints;
        this.resourceReferenceHandler = resourceReferenceHandler;
        this.bufferedImageContainerFactory = new BufferedImageContainerFactory(hints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IImageContainer create(IResourceReference resourceReference) throws IOException {
        IImageInputStreamConnector imageInputStreamConnector = this.createInputStreamConnector(resourceReference);
        IImageIoImageContainerSettings imageIoSettings = IImageIoImageContainerSettings.getSettings(this.hints);
        IImageContainerSettings settings = IImageContainerSettings.getSettings(this.hints);
        try (ImageInputStream imageInputStream = imageInputStreamConnector.connect();){
            IObjectList imageReaders = Streams.of(IOException.class, ImageIO.getImageReaders(imageInputStream)).asObjectList();
            if (imageReaders.isEmpty()) {
                imageInputStream.close();
                logger.log(ILevel.WARNING, "missing reader");
                logger.log(ILevel.DEBUG, "missing reader", (Throwable)new IOException("missing reader"));
                IImageContainer iImageContainer = this.bufferedImageContainerFactory.create(ImageUtilities.create(100, 100));
                return iImageContainer;
            }
            ImageReader imageReader = imageIoSettings.getImageReader((IObjectList<ImageReader>)imageReaders);
            imageReader.addIIOReadWarningListener((source, warning) -> settings.getImageContainerListener().eventOccurred(warning, null, MessageType.WARNING));
            imageReader.setInput(imageInputStream);
            int index = imageReader.getMinIndex();
            int width = imageReader.getWidth(index);
            int height = imageReader.getHeight(index);
            Iterator<ImageTypeSpecifier> imageTypes = imageReader.getImageTypes(index);
            ImageTypeSpecifier imageType = imageIoSettings.getImageTypeSpecifier((IObjectList<ImageTypeSpecifier>)Streams.of(IOException.class, imageTypes).asObjectList());
            ColorModel colorModel = imageType.getColorModel();
            ColorSpace colorSpace = colorModel.getColorSpace();
            int numColorComponents = colorSpace.getNumComponents();
            int numBands = imageType.getNumBands();
            int colorSpaceType = colorSpace.getType();
            boolean isIndexed = colorModel instanceof IndexColorModel;
            ImageIoImageMetadata metadata = new ImageIoImageMetadata(index, width, height, numColorComponents, numBands, colorSpaceType, colorModel.getTransferType(), colorModel.getTransparency(), imageType, isIndexed, isIndexed ? ImageUtilities.getColors((IndexColorModel)colorModel) : List.of());
            imageReader.setInput(null);
            imageReader.dispose();
            ImageIoImageContainer imageIoImageContainer = new ImageIoImageContainer(this.hints, (IImageMetadata)metadata, imageInputStreamConnector, this.metadataAdjustor);
            return imageIoImageContainer;
        }
        catch (IOException exception) {
            logger.log(ILevel.WARNING, exception.getMessage());
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            settings.getImageContainerListener().eventOccurred(exception.getMessage(), exception, MessageType.ERROR);
            return this.bufferedImageContainerFactory.create(ImageUtilities.create(100, 100));
        }
    }

    public boolean isSupported(IImageInputStreamConnector imageInputStreamProvider) {
        boolean bl;
        block9: {
            IImageIoImageContainerSettings imageIoSettings = IImageIoImageContainerSettings.getSettings(this.hints);
            if (!imageIoSettings.isEnabled()) {
                return false;
            }
            IImageContainerSettings settings = IImageContainerSettings.getSettings(this.hints);
            ImageInputStream imageInputStream = imageInputStreamProvider.connect();
            try {
                IObjectList imageReaders = Streams.of(IOException.class, ImageIO.getImageReaders(imageInputStream)).asObjectList();
                boolean bl2 = bl = !imageReaders.isEmpty();
                if (imageInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (imageInputStream != null) {
                        try {
                            imageInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    settings.getImageContainerListener().eventOccurred(exception.getMessage(), exception, MessageType.ERROR);
                    return false;
                }
            }
            imageInputStream.close();
        }
        return bl;
    }

    public IImageInputStreamConnector createInputStreamConnector(IResourceReference reference) {
        return () -> this.connect(reference);
    }

    private ImageInputStream connect(final IResourceReference resourceReference) throws IOException {
        try {
            return (ImageInputStream)resourceReference.accept((IResourceReferenceVisitor)new IResourceReferenceVisitor<ImageInputStream, IOException>(){

                public ImageInputStream visitUrlResource(UniformResourceLocatorReference urlResourceReference) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public ImageInputStream visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                    return new FileImageInputStream(fileResourceReference.getFile());
                }

                public ImageInputStream visitURLResource(URLResourceReference urlResourceReference) throws IOException {
                    if (ImageIoImageContainerFactory.this.resourceReferenceHandler.isFileSystemResource(resourceReference)) {
                        return ImageIoImageContainerFactory.this.openAsFileIfPossible(resourceReference);
                    }
                    return new MemoryCacheImageInputStream(ImageIoImageContainerFactory.this.resourceReferenceHandler.openInputStream(resourceReference, value -> value != null && value.startsWith("image")));
                }

                public ImageInputStream visitURIResource(URIResourceReference uriResourceReference) throws IOException {
                    if (ImageIoImageContainerFactory.this.resourceReferenceHandler.isFileSystemResource(resourceReference)) {
                        return ImageIoImageContainerFactory.this.openAsFileIfPossible(resourceReference);
                    }
                    return new MemoryCacheImageInputStream(ImageIoImageContainerFactory.this.resourceReferenceHandler.openInputStream(resourceReference, value -> value != null && value.startsWith("image")));
                }

                public ImageInputStream visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                    return new SeekableImageInputStream((SeekableStream)new ByteArraySeekableStream(memoryResourceReference.getBuffer()));
                }

                public ImageInputStream visitPathResource(PathResourceReference pathResourceReference) throws IOException {
                    return this.visitFileResource(new FileResourceReference(pathResourceReference.getPath().toFile()));
                }
            });
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed reading the provided resource reference: %s", this.toPrintableString(resourceReference)), e);
        }
    }

    private ImageInputStream openAsFileIfPossible(IResourceReference reference) throws IOException {
        try {
            return new FileImageInputStream(this.resourceReferenceHandler.getFile(reference));
        }
        catch (URISyntaxException e) {
            return new MemoryCacheImageInputStream(this.resourceReferenceHandler.openInputStream(reference));
        }
    }

    private String toPrintableString(IResourceReference resourceReference) {
        String string = this.resourceReferenceHandler.toString(resourceReference);
        try {
            IUrl url = new UrlParser().parse(string);
            if (url.getPassword() != null) {
                return new UrlBuilder(url).setPassword("**********").build().toString();
            }
            return new UrlBuilder(url).build().toString();
        }
        catch (CreationException exception) {
            return string;
        }
    }
}

