/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen;

import net.anwiba.commons.image.histogram.HistogramBuilder;
import org.eclipse.imagen.Histogram;

public class ImagenHistogramToHistogramConverter {
    public net.anwiba.commons.image.histogram.Histogram convert(Histogram histogram) {
        if (histogram == null) {
            return null;
        }
        HistogramBuilder builder = new HistogramBuilder();
        int numBands = histogram.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            double lowValue = histogram.getLowValue(i);
            double highValue = histogram.getHighValue(i);
            int numBins = histogram.getNumBins(i);
            double binWidth = (highValue - lowValue) / (double)numBins;
            double pos = lowValue;
            int[] bins = histogram.getBins(i);
            long sum = this.sum(bins);
            if (sum == 0L) continue;
            double factor = 1.0 / (double)sum;
            for (int j = 0; j < numBins; ++j) {
                double next = pos + binWidth;
                int count = bins[j];
                if (count <= 0) {
                    pos = next;
                    continue;
                }
                double percent = factor * (double)count;
                builder.add(i, pos, next, count, percent);
                pos = next;
            }
        }
        return builder.build();
    }

    private long sum(int[] bins) {
        long sum = 0L;
        for (int i = 0; i < bins.length; ++i) {
            sum += (long)bins[i];
        }
        return sum;
    }
}

