/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen;

import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.List;
import net.anwiba.commons.image.AbstractImageContainer;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageMetadata;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.ImageUtilities;
import net.anwiba.commons.image.imagen.ISeekableStreamConnector;
import net.anwiba.commons.image.imagen.ImagenImageContainerUtilities;
import net.anwiba.commons.image.imagen.ImagenImageMetadata;
import net.anwiba.commons.image.imagen.PlanarImageOperatorFactory;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.thread.cancel.ICanceler;
import org.eclipse.imagen.Histogram;
import org.eclipse.imagen.JAI;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.codec.SeekableStream;
import org.eclipse.imagen.operator.StreamDescriptor;

class ImagenImageContainer
extends AbstractImageContainer {
    private final ISeekableStreamConnector seekableStreamConnector;

    public ImagenImageContainer(RenderingHints hints, IImageMetadata metadata, ISeekableStreamConnector seekableStreamConnector, IImageMetadataAdjustor metadataAdjustor) {
        this(hints, metadata, (IObjectList<IImageOperation>)new ObjectList(), seekableStreamConnector, metadataAdjustor);
    }

    public ImagenImageContainer(RenderingHints hints, IImageMetadata metadata, IObjectList<IImageOperation> operations, ISeekableStreamConnector seekableStreamConnector, IImageMetadataAdjustor metadataAdjustor) {
        super(hints, metadata, operations, metadataAdjustor);
        this.seekableStreamConnector = seekableStreamConnector;
    }

    @Override
    protected IImageMetadata read(ICanceler canceler, RenderingHints hints) throws CanceledException, IOException {
        RenderedOp renderedOp = null;
        try {
            ImagenImageMetadata imagenImageMetadata;
            block10: {
                SeekableStream inputStream = this.seekableStreamConnector.connect();
                try {
                    renderedOp = StreamDescriptor.create((SeekableStream)inputStream, null, (RenderingHints)hints);
                    ColorModel colorModel = renderedOp.getColorModel();
                    boolean isIndexed = colorModel instanceof IndexColorModel;
                    imagenImageMetadata = new ImagenImageMetadata(renderedOp.getWidth(), renderedOp.getHeight(), colorModel.getNumColorComponents(), colorModel.getNumComponents(), colorModel.getColorSpace().getType(), colorModel.getTransferType(), colorModel.getTransparency(), isIndexed, isIndexed ? ImageUtilities.getColors((IndexColorModel)colorModel) : List.of());
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return imagenImageMetadata;
        }
        finally {
            if (renderedOp != null) {
                renderedOp.dispose();
            }
        }
    }

    @Override
    protected IImageContainer adapt(RenderingHints hints, IImageMetadata metadata, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) {
        return new ImagenImageContainer(hints, metadata, operations, this.seekableStreamConnector, metadataAdjustor);
    }

    @Override
    protected BufferedImage read(IMessageCollector messageCollector, ICanceler canceler, RenderingHints hints, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) throws CanceledException, IOException {
        return (BufferedImage)this.read(messageCollector, canceler, hints, operations, metadataAdjustor, image -> image.getAsBufferedImage());
    }

    @Override
    protected Number[][] read(IMessageCollector messageCollector, ICanceler canceler, RenderingHints hints, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor, int x, int y, int width, int height) throws CanceledException, IOException {
        Raster raster = (Raster)this.read(messageCollector, canceler, hints, operations, metadataAdjustor, image -> (Raster)ImageUtilities.getIntersection(new Dimension(image.getWidth(), image.getHeight()), x, y, width, height).convert(intersection -> {
            RenderedOp cropped = ImagenImageContainerUtilities.crop(hints, (RenderedImage)image, x, y, Math.max(width, 10), Math.max(height, 10));
            if (cropped == null) {
                return null;
            }
            if (cropped.getWidth() == 0 || cropped.getHeight() == 0) {
                return image.getData(intersection);
            }
            return cropped.getData(intersection);
        }).getOr(() -> null));
        if (raster == null) {
            return null;
        }
        return ImageUtilities.getValues(raster);
    }

    private <O> O read(IMessageCollector messageCollector, ICanceler canceler, RenderingHints hints, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor, IConverter<PlanarImage, O, IOException> converter) throws CanceledException, IOException {
        RenderedOp planarImage = null;
        if (operations.isEmpty()) {
            try {
                Object object;
                block21: {
                    SeekableStream inputStream = this.seekableStreamConnector.connect();
                    try {
                        planarImage = StreamDescriptor.create((SeekableStream)inputStream, null, (RenderingHints)hints);
                        Object object2 = object = planarImage == null ? null : converter.convert((Object)planarImage);
                        if (inputStream == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return (O)object;
            }
            finally {
                if (planarImage != null) {
                    planarImage.dispose();
                }
            }
        }
        IImageMetadata metadata = this.read(canceler, hints);
        try {
            Object object;
            block22: {
                SeekableStream inputStream = this.seekableStreamConnector.connect();
                try {
                    RenderedOp renderedOp = StreamDescriptor.create((SeekableStream)inputStream, null, (RenderingHints)hints);
                    planarImage = new PlanarImageOperatorFactory(metadataAdjustor).create((ImagenImageMetadata)metadata, operations, hints).execute(canceler, (PlanarImage)renderedOp);
                    Object object3 = object = planarImage == null ? null : converter.convert((Object)planarImage);
                    if (inputStream == null) break block22;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return (O)object;
        }
        finally {
            if (planarImage != null) {
                planarImage.dispose();
            }
        }
    }

    @Override
    protected Histogram readHistogram(IMessageCollector messageCollector, ICanceler canceler, RenderingHints hints, IObjectList<IImageOperation> operations, IImageMetadataAdjustor metadataAdjustor) throws CanceledException, IOException {
        return (Histogram)this.read(messageCollector, canceler, hints, operations, metadataAdjustor, image -> {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            RenderedOp op = JAI.create((String)"histogram", (ParameterBlock)pb, null);
            Histogram histogram = (Histogram)op.getProperty("histogram");
            return histogram;
        });
    }
}

