/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Set;
import net.anwiba.commons.image.IImageContainer;
import net.anwiba.commons.image.IImageContainerSettings;
import net.anwiba.commons.image.IImageMetadataAdjustor;
import net.anwiba.commons.image.imagen.IImagenImageContainerSettings;
import net.anwiba.commons.image.imagen.ISeekableStreamConnector;
import net.anwiba.commons.image.imagen.ImagenImageContainer;
import net.anwiba.commons.image.imagen.ImagenImageMetadataAdjustor;
import net.anwiba.commons.image.imagen.InputStreamConnectorFactory;
import net.anwiba.commons.image.imagen.RenderedImageContainer;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import org.eclipse.imagen.media.codec.ImageCodec;
import org.eclipse.imagen.media.codec.SeekableStream;
import org.eclipse.imagen.media.codec.TIFFDirectory;
import org.eclipse.imagen.media.codec.TIFFField;

public class ImagenImageContainerFactory {
    private final RenderingHints hints;
    private final InputStreamConnectorFactory inputStreamConnectorFactory;
    private final IImageMetadataAdjustor metadataAdjustor = new ImagenImageMetadataAdjustor();

    public ImagenImageContainerFactory(RenderingHints hints, IResourceReferenceHandler resourceReferenceHandler) {
        this.hints = hints;
        this.inputStreamConnectorFactory = new InputStreamConnectorFactory(resourceReferenceHandler);
    }

    public IImageContainer create(ISeekableStreamConnector seekableStreamConnector) {
        return new ImagenImageContainer(this.hints, null, seekableStreamConnector, this.metadataAdjustor);
    }

    public IImageContainer create(BufferedImage image) {
        return new RenderedImageContainer(this.hints, image, this.metadataAdjustor);
    }

    public boolean isSupported(SeekableStream inputStream) {
        IImagenImageContainerSettings imagenSettings = IImagenImageContainerSettings.getSettings(this.hints);
        if (!imagenSettings.isEnabled()) {
            return false;
        }
        IImageContainerSettings settings = IImageContainerSettings.getSettings(this.hints);
        try {
            String[] decoderNames = ImageCodec.getDecoderNames((SeekableStream)inputStream);
            if (decoderNames != null && decoderNames.length > 0) {
                if (Set.of(decoderNames).contains("jpeg")) {
                    return false;
                }
                if (Set.of(decoderNames).contains("tiff")) {
                    char[] planarConfiguration;
                    inputStream.seek(0L);
                    TIFFDirectory directory = new TIFFDirectory(inputStream, 0);
                    TIFFField sfield = directory.getField(277);
                    int samplesPerPixel = sfield == null ? 1 : (int)sfield.getAsLong(0);
                    TIFFField planarConfigurationField = directory.getField(284);
                    if (planarConfigurationField == null) {
                        char[] cArray = new char[1];
                        v1 = cArray;
                        cArray[0] = '\u0001';
                    } else {
                        v1 = planarConfiguration = planarConfigurationField.getAsChars();
                    }
                    if (planarConfiguration[0] != '\u0001' && samplesPerPixel != 1) {
                        return false;
                    }
                    TIFFField bitsField = directory.getField(258);
                    char[] bitsPerSample = null;
                    if (bitsField != null) {
                        bitsPerSample = bitsField.getAsChars();
                    } else {
                        bitsPerSample = new char[]{'\u0001'};
                        for (int i = 1; i < bitsPerSample.length; ++i) {
                            if (bitsPerSample[i] == bitsPerSample[0]) continue;
                            return false;
                        }
                    }
                    char sampleSize = bitsPerSample[0];
                    TIFFField sampleFormatField = directory.getField(339);
                    char[] sampleFormat = null;
                    if (sampleFormatField != null) {
                        sampleFormat = sampleFormatField.getAsChars();
                        for (int l = 1; l < sampleFormat.length; ++l) {
                            if (sampleFormat[l] == sampleFormat[0]) continue;
                            return false;
                        }
                    }
                    TIFFField photoInterpField = directory.getField(262);
                    int photometricType = -1;
                    if (photoInterpField != null) {
                        photometricType = (int)photoInterpField.getAsLong(0);
                    }
                    if (photometricType == 5 && sampleSize == '\b' && samplesPerPixel == 5) {
                        return false;
                    }
                    TIFFField compField = directory.getField(259);
                    int compression = compField == null ? 1 : compField.getAsInt(0);
                    switch (compression) {
                        case 6: 
                        case 7: {
                            return false;
                        }
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
        catch (RuntimeException exception) {
            settings.getImageContainerListener().eventOccurred(exception.getMessage(), exception, MessageType.ERROR);
            return false;
        }
        catch (IOException exception) {
            settings.getImageContainerListener().eventOccurred(exception.getMessage(), exception, MessageType.ERROR);
            return false;
        }
    }

    public ISeekableStreamConnector createInputStreamConnector(IResourceReference reference) {
        return this.inputStreamConnectorFactory.create(reference);
    }
}

