/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Hashtable;
import java.util.Objects;
import net.anwiba.commons.image.ImageUtilities;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import org.eclipse.imagen.Histogram;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.JAI;
import org.eclipse.imagen.LookupTableJAI;
import org.eclipse.imagen.OpImage;
import org.eclipse.imagen.ParameterBlockJAI;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.RenderedImageAdapter;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.operator.BandCombineDescriptor;
import org.eclipse.imagen.operator.BandSelectDescriptor;
import org.eclipse.imagen.operator.ColorQuantizerDescriptor;
import org.eclipse.imagen.operator.ColorQuantizerType;
import org.eclipse.imagen.operator.CropDescriptor;
import org.eclipse.imagen.operator.InvertDescriptor;
import org.eclipse.imagen.operator.LookupDescriptor;
import org.eclipse.imagen.operator.ScaleDescriptor;
import org.eclipse.imagen.operator.TranslateDescriptor;

public class ImagenImageContainerUtilities {
    private static ILogger logger = Logging.getLogger(ImagenImageContainerUtilities.class);

    public static RenderedOp crop(RenderingHints hints, RenderedImage renderedImage, float x, float y, float width, float height) {
        Rectangle imageBounds = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle cropBounds = new Rectangle2D.Float(x, y, width, height).getBounds();
        if (cropBounds.isEmpty()) {
            return null;
        }
        if (!imageBounds.contains(cropBounds)) {
            if (!imageBounds.intersects(cropBounds)) {
                return null;
            }
            Rectangle intersection = imageBounds.intersection(cropBounds);
            return CropDescriptor.create((RenderedImage)renderedImage, (Float)ImagenImageContainerUtilities.toFloat(intersection.x), (Float)ImagenImageContainerUtilities.toFloat(intersection.y), (Float)ImagenImageContainerUtilities.toFloat(intersection.width), (Float)ImagenImageContainerUtilities.toFloat(intersection.height), (RenderingHints)hints);
        }
        return CropDescriptor.create((RenderedImage)renderedImage, (Float)ImagenImageContainerUtilities.toFloat(x), (Float)ImagenImageContainerUtilities.toFloat(y), (Float)ImagenImageContainerUtilities.toFloat(width), (Float)ImagenImageContainerUtilities.toFloat(height), (RenderingHints)hints);
    }

    public static RenderedOp translate(RenderingHints hints, RenderedImage renderedImage, float x, float y, Interpolation interpolation) {
        return TranslateDescriptor.create((RenderedImage)renderedImage, (Float)ImagenImageContainerUtilities.toFloat(x), (Float)ImagenImageContainerUtilities.toFloat(y), (Interpolation)interpolation, (RenderingHints)hints);
    }

    public static RenderedOp scale(RenderingHints hints, RenderedImage renderedImage, float xFactor, float yFactor, Interpolation interpolation) {
        return ScaleDescriptor.create((RenderedImage)renderedImage, (Float)ImagenImageContainerUtilities.toFloat(xFactor), (Float)ImagenImageContainerUtilities.toFloat(yFactor), (Float)ImagenImageContainerUtilities.toFloat(0.0f), (Float)ImagenImageContainerUtilities.toFloat(0.0f), (Interpolation)interpolation, (RenderingHints)hints);
    }

    public static PlanarImage toInverted(RenderingHints hints, RenderedImage source) {
        RenderedImage image = source.getColorModel().getColorSpace().getType() == 6 ? ImageUtilities.toRGBA(hints, source) : source;
        return InvertDescriptor.create((RenderedImage)image, (RenderingHints)hints);
    }

    public static PlanarImage toGrayScale(RenderingHints hints, RenderedImage source) {
        if (source.getColorModel().getColorSpace().getType() == 6) {
            return ImagenImageContainerUtilities.toPlanarImage(source);
        }
        RenderedImage image = source.getColorModel() instanceof IndexColorModel ? ImagenImageContainerUtilities.convertIndexColorModelToARGB(hints, source, (IndexColorModel)source.getColorModel()) : source;
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        ImageLayout imageLayout = new ImageLayout(image);
        imageLayout.setColorModel((ColorModel)colorModel);
        imageLayout.setSampleModel(((ColorModel)colorModel).createCompatibleSampleModel(image.getWidth(), image.getHeight()));
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        renderingHints.add(hints);
        int expandedNumBands = OpImage.getExpandedNumBands((SampleModel)image.getSampleModel(), (ColorModel)image.getColorModel()) + 1;
        return BandCombineDescriptor.create((RenderedImage)image, (double[][])(switch (expandedNumBands) {
            case 5 -> new double[][]{{0.114, 0.587, 0.299, 0.0, 0.0}};
            case 4 -> new double[][]{{0.114, 0.587, 0.299, 0.0}};
            case 3 -> new double[][]{{0.114, 0.587, 0.299}};
            case 2 -> new double[][]{{1.0, 0.0}};
            default -> new double[][]{{1.0}};
        }), (RenderingHints)renderingHints);
    }

    public static PlanarImage toOpacity(RenderingHints hints, RenderedImage source, float factor) {
        if ((double)factor >= 1.0 || factor < 0.0f) {
            return ImagenImageContainerUtilities.toPlanarImage(source);
        }
        ColorModel sourceColorModel = source.getColorModel();
        if (sourceColorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)sourceColorModel;
            int mapSize = indexColorModel.getMapSize();
            byte[][] data = new byte[4][mapSize];
            indexColorModel.getReds(data[0]);
            indexColorModel.getGreens(data[1]);
            indexColorModel.getBlues(data[2]);
            indexColorModel.getAlphas(data[3]);
            for (int i = 0; i < mapSize; ++i) {
                int alpha = data[3][i] < 0 ? data[3][i] + 256 : data[3][i];
                alpha = (int)((float)alpha * factor);
                data[3][i] = (byte)(alpha > 128 ? alpha - 256 : alpha);
            }
            LookupTableJAI lut = new LookupTableJAI(data);
            return LookupDescriptor.create((RenderedImage)source, (LookupTableJAI)lut, (RenderingHints)hints);
        }
        return ImagenImageContainerUtilities.toPlanarImage(ImageUtilities.toOpacity(hints, source, factor));
    }

    public static PlanarImage toMapped(RenderingHints hints, PlanarImage source, int[] mapping) {
        if (mapping == null || mapping.length == 0) {
            return source;
        }
        if (source.getColorModel() instanceof IndexColorModel) {
            return source;
        }
        if (mapping.length == source.getColorModel().getNumColorComponents() && ImagenImageContainerUtilities.isIdentity(mapping)) {
            return source;
        }
        return BandSelectDescriptor.create((RenderedImage)source, (int[])mapping, (RenderingHints)hints);
    }

    private static boolean isIdentity(int[] mapping) {
        for (int i = 0; i < mapping.length; ++i) {
            if (i < mapping.length && i == mapping[i]) continue;
            return false;
        }
        return true;
    }

    public static PlanarImage toPlanarImage(RenderedImage image) {
        if (image instanceof PlanarImage) {
            return (PlanarImage)image;
        }
        return new RenderedImageAdapter(image);
    }

    public static PlanarImage toTransparent(RenderingHints hints, RenderedImage source, Color color) {
        RenderedImage image = source.getColorModel() instanceof IndexColorModel ? source : ColorQuantizerDescriptor.create((RenderedImage)source, (ColorQuantizerType)ColorQuantizerDescriptor.OCTTREE, (Integer)255, (Integer)300, null, (Integer)2, (Integer)2, null);
        ColorModel colorModel = image.getColorModel();
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        int mapSize = indexColorModel.getMapSize();
        byte[][] data = new byte[4][mapSize];
        indexColorModel.getReds(data[0]);
        indexColorModel.getGreens(data[1]);
        indexColorModel.getBlues(data[2]);
        indexColorModel.getAlphas(data[3]);
        int red = color.getRed() > 128 ? color.getRed() - 256 : color.getRed();
        int green = color.getGreen() > 128 ? color.getGreen() - 256 : color.getGreen();
        int blue = color.getBlue() > 128 ? color.getBlue() - 256 : color.getBlue();
        for (int i = 0; i < mapSize; ++i) {
            if (data[0][i] != red || data[1][i] != green || data[2][i] != blue) continue;
            data[3][i] = 0;
        }
        LookupTableJAI lut = new LookupTableJAI(data);
        return LookupDescriptor.create((RenderedImage)image, (LookupTableJAI)lut, (RenderingHints)hints);
    }

    public static RenderedImage convertIndexColorModelToARGB(RenderingHints hints, RenderedImage source, IndexColorModel indexColorModel) {
        int numberOfBands = indexColorModel.hasAlpha() ? 4 : 3;
        byte[][] data = new byte[numberOfBands][indexColorModel.getMapSize()];
        if (indexColorModel.hasAlpha()) {
            indexColorModel.getAlphas(data[3]);
        }
        indexColorModel.getReds(data[0]);
        indexColorModel.getGreens(data[1]);
        indexColorModel.getBlues(data[2]);
        LookupTableJAI lookupTable = new LookupTableJAI(data);
        return LookupDescriptor.create((RenderedImage)source, (LookupTableJAI)lookupTable, (RenderingHints)hints);
    }

    private static Float floor(float x) {
        return Float.valueOf(Double.valueOf(Math.floor(x)).floatValue());
    }

    private static Float ceil(float x) {
        return Float.valueOf(Double.valueOf(Math.ceil(x)).floatValue());
    }

    private static Float toFloat(float value) {
        return Float.valueOf(value);
    }

    public static Interpolation getInterpolation(RenderingHints hints) {
        Object object = hints.get(RenderingHints.KEY_INTERPOLATION);
        if (Objects.equals(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, object)) {
            return Interpolation.getInstance((int)0);
        }
        if (Objects.equals(RenderingHints.VALUE_INTERPOLATION_BILINEAR, object)) {
            return Interpolation.getInstance((int)1);
        }
        if (Objects.equals(RenderingHints.VALUE_INTERPOLATION_BICUBIC, object)) {
            return Interpolation.getInstance((int)2);
        }
        return Interpolation.getInstance((int)0);
    }

    public static BufferedImage convertTo256ColorIndexColorModelImage(BufferedImage image) {
        RenderedOp colorQuantizedImage = ImagenImageContainerUtilities.createColorQuantizedImage(ImagenImageContainerUtilities.createWhiteBackgroundedImage(image), 255);
        IndexColorModel colorModel = (IndexColorModel)colorQuantizedImage.getColorModel();
        byte[] reds = new byte[256];
        colorModel.getReds(reds);
        byte[] greens = new byte[256];
        colorModel.getGreens(greens);
        byte[] blues = new byte[256];
        colorModel.getBlues(blues);
        int transparentPixelIndex = 255;
        IndexColorModel transparentColorModel = new IndexColorModel(colorModel.getPixelSize(), 256, reds, greens, blues, 255);
        BufferedImage transparentImage = new BufferedImage(transparentColorModel, colorQuantizedImage.copyData(), false, new Hashtable());
        WritableRaster raster = transparentImage.getRaster();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                boolean transparent;
                int rgb = image.getRGB(x, y);
                boolean bl = transparent = (rgb >> 24 & 0xFF) == 0;
                if (!transparent) continue;
                raster.setDataElements(x, y, new byte[]{-1});
            }
        }
        return transparentImage;
    }

    public static BufferedImage createWhiteBackgroundedImage(BufferedImage image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getWidth());
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    private static RenderedOp createColorQuantizedImage(BufferedImage image, int colorCount) {
        RenderedOp op = ImagenImageContainerUtilities.colorQuantize(image, colorCount);
        return ImagenImageContainerUtilities.expandColorMap(op);
    }

    public static RenderedOp colorQuantize(RenderedImage image, int colorCount) {
        int numComponents = image.getColorModel().getNumComponents();
        int[] bOffs = new int[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            bOffs[i] = numComponents - i - 1;
        }
        PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(0, image.getWidth(), image.getHeight(), numComponents, image.getWidth() * numComponents, bOffs);
        ImageLayout layout = new ImageLayout();
        layout.setSampleModel((SampleModel)sampleModel);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return ColorQuantizerDescriptor.create((RenderedImage)image, (ColorQuantizerType)ColorQuantizerDescriptor.MEDIANCUT, (Integer)colorCount, null, null, null, null, (RenderingHints)renderingHints);
    }

    private static RenderedOp expandColorMap(RenderedOp op) {
        IndexColorModel indexColorModel = (IndexColorModel)op.getColorModel();
        ParameterBlockJAI parameterBlock = new ParameterBlockJAI("format");
        parameterBlock.addSource((Object)op);
        parameterBlock.setParameter("dataType", (Object)0);
        ImageLayout layout = new ImageLayout();
        byte[] reds = new byte[256];
        indexColorModel.getReds(reds);
        byte[] greens = new byte[256];
        indexColorModel.getGreens(greens);
        byte[] blues = new byte[256];
        indexColorModel.getBlues(blues);
        IndexColorModel colorModel = new IndexColorModel(8, 256, reds, greens, blues);
        layout.setColorModel((ColorModel)colorModel);
        SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(op.getWidth(), op.getHeight());
        layout.setSampleModel(sampleModel);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return JAI.create((String)"format", (ParameterBlock)parameterBlock, (RenderingHints)renderingHints);
    }

    public static Histogram getHistogram(RenderedImage renderedImage, RenderingHints hints) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(renderedImage);
        RenderedOp op = JAI.create((String)"histogram", (ParameterBlock)pb, (RenderingHints)hints);
        return (Histogram)op.getProperty("histogram");
    }
}

