/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.imagen.encoder;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.anwiba.commons.image.ImageUtilities;
import net.anwiba.commons.image.encoder.IEncoder;
import net.anwiba.commons.lang.stream.Streams;
import org.eclipse.imagen.media.codec.ImageEncoder;

public abstract class AbstractEncoder
implements IEncoder {
    private final String mimetype;

    public AbstractEncoder(String mimetype) {
        this.mimetype = mimetype;
    }

    @Override
    public void encode(BufferedImage image, OutputStream out) throws IOException {
        if (Objects.equals(this.mimetype, "image/gif")) {
            ImageIO.write((RenderedImage)image, "GIF", new MemoryCacheImageOutputStream(out));
            return;
        }
        ImageEncoder encoder = this.getEncoder(image, out);
        if (encoder != null) {
            encoder.encode((RenderedImage)image);
            return;
        }
        ImageWriter writer = this.getWriter(out);
        try {
            if (writer != null) {
                if (Objects.equals(writer.getClass().getName(), "com.sun.imageio.plugins.jpeg.JPEGImageWriter")) {
                    JPEGImageWriteParam jpegParams = new JPEGImageWriteParam(null);
                    jpegParams.setCompressionMode(2);
                    jpegParams.setCompressionQuality(0.9f);
                    writer.setOutput(new MemoryCacheImageOutputStream(out));
                    BufferedImage opaqueBufferedImage = ImageUtilities.createOpaqueImage(image);
                    writer.write(null, new IIOImage(opaqueBufferedImage, null, null), jpegParams);
                    return;
                }
                writer.write(image);
                return;
            }
        }
        catch (IOException e) {
            writer.abort();
            throw e;
        }
        finally {
            writer.dispose();
            out.flush();
        }
        throw new IOException();
    }

    private ImageWriter getWriter(OutputStream out) throws IOException {
        return (ImageWriter)Streams.of(IOException.class, ImageIO.getImageWritersByMIMEType(this.mimetype)).first(w -> this.isAccaptable((ImageWriter)w)).consume(w -> w.setOutput(new MemoryCacheImageOutputStream(out))).get();
    }

    protected boolean isAccaptable(ImageWriter writer) {
        return writer.getClass().getName().startsWith("com.sun.imageio.plugins");
    }

    protected abstract ImageEncoder getEncoder(RenderedImage var1, OutputStream var2);
}

