/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.operation;

import java.util.Arrays;
import net.anwiba.commons.image.operation.IImageOperation;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public class ImageMapBandsOperation
implements IImageOperation {
    private final int[] mapping;

    public ImageMapBandsOperation(int[] bandMapping) {
        this.mapping = bandMapping;
    }

    public int[] getBandMapping() {
        return this.mapping;
    }

    public int getMappingSize() {
        return this.mapping.length;
    }

    public boolean isIdentity() {
        for (int i = 0; i < this.mapping.length; ++i) {
            if (i < this.mapping.length && i == this.mapping[i]) continue;
            return false;
        }
        return true;
    }

    public boolean hasDuplicate() {
        for (int i = 0; i < this.mapping.length; ++i) {
            int value = this.mapping[i];
            for (int j = i + 1; j < this.mapping.length; ++j) {
                if (value != this.mapping[j]) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mapping);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageMapBandsOperation other = (ImageMapBandsOperation)obj;
        return Arrays.equals(this.mapping, other.mapping);
    }

    public static IOptional<ImageMapBandsOperation, RuntimeException> aggregate(IObjectList<IImageOperation> imageOperations) {
        ImageMapBandsOperation mapBandsOperation = null;
        for (IImageOperation operation : imageOperations) {
            if (!(operation instanceof ImageMapBandsOperation)) continue;
            if (mapBandsOperation == null) {
                mapBandsOperation = (ImageMapBandsOperation)operation;
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(mapBandsOperation);
    }
}

