/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.renderable;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Vector;
import java.util.stream.Collectors;
import org.eclipse.imagen.PlanarImage;

public class RenderableImageAdapter
implements RenderableImage {
    private final RenderedImage renderedImage;

    public RenderableImageAdapter(RenderedImage renderedImage) {
        this.renderedImage = renderedImage;
    }

    @Override
    public Vector<RenderableImage> getSources() {
        Vector<RenderedImage> sources = this.renderedImage.getSources();
        return new Vector<RenderableImage>(sources.stream().map(i -> new RenderableImageAdapter(this.renderedImage)).collect(Collectors.toList()));
    }

    @Override
    public Object getProperty(String name) {
        return this.renderedImage.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.renderedImage.getPropertyNames();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public float getWidth() {
        return this.renderedImage.getWidth();
    }

    @Override
    public float getHeight() {
        return this.renderedImage.getHeight();
    }

    @Override
    public float getMinX() {
        return this.renderedImage.getMinX();
    }

    @Override
    public float getMinY() {
        return this.renderedImage.getMinY();
    }

    @Override
    public RenderedImage createScaledRendering(int w, int h, RenderingHints hints) {
        if (w == 0 && h == 0) {
            throw new IllegalArgumentException();
        }
        int width = w == 0 ? Math.round((float)h * (this.getWidth() / this.getHeight())) : w;
        int height = h == 0 ? Math.round((float)w * (this.getHeight() / this.getWidth())) : h;
        AffineTransform scaleTransformer = AffineTransform.getScaleInstance((float)width / this.getWidth(), (float)height / this.getHeight());
        return this.createRendering(new RenderContext(scaleTransformer, hints));
    }

    @Override
    public RenderedImage createDefaultRendering() {
        return this.renderedImage;
    }

    @Override
    public RenderedImage createRendering(final RenderContext renderContext) {
        RenderedImageFactory factory = new RenderedImageFactory(){

            @Override
            public RenderedImage create(ParameterBlock paramBlock, RenderingHints hints) {
                AffineTransformOp op = new AffineTransformOp(renderContext.getTransform(), hints);
                return op.filter(this.getBufferImage(), null);
            }

            private BufferedImage getBufferImage() {
                if (RenderableImageAdapter.this.renderedImage instanceof BufferedImage) {
                    return (BufferedImage)RenderableImageAdapter.this.renderedImage;
                }
                return PlanarImage.wrapRenderedImage((RenderedImage)RenderableImageAdapter.this.renderedImage).getAsBufferedImage();
            }
        };
        ParameterBlock parameterBlock = new ParameterBlock();
        return factory.create(parameterBlock, renderContext.getRenderingHints());
    }
}

