/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.anwiba.commons.injection.DefaultInjectionValueProvider;
import net.anwiba.commons.injection.IBinding;
import net.anwiba.commons.injection.IInjectingFactory;
import net.anwiba.commons.injection.IInjectionValueProvider;
import net.anwiba.commons.injection.IInjectionValueProviderBuilder;
import net.anwiba.commons.injection.IInjektionAnalyserResult;
import net.anwiba.commons.injection.IValueInjectionAnalyser;
import net.anwiba.commons.injection.InjectionValueProvider;
import net.anwiba.commons.injection.InjektingObjectFactory;
import net.anwiba.commons.injection.ValueInjectionAnalyser;
import net.anwiba.commons.injection.binding.ClassBinding;
import net.anwiba.commons.injection.utilities.IValueHolder;
import net.anwiba.commons.injection.utilities.ListValueHolder;
import net.anwiba.commons.injection.utilities.SingleValueHolder;
import net.anwiba.commons.reflection.CreationException;

public class InjectionValueProviderBuilder
implements IInjectionValueProviderBuilder {
    private final IValueInjectionAnalyser analyser = new ValueInjectionAnalyser();
    private final Map<IBinding, IValueHolder> services = new HashMap<IBinding, IValueHolder>();
    private final Map<IBinding, IValueHolder> results = new HashMap<IBinding, IValueHolder>();
    private final Map<IBinding, IBinding> links = new HashMap<IBinding, IBinding>();
    private final IInjectionValueProvider valueProvider;

    public InjectionValueProviderBuilder() {
        this(new DefaultInjectionValueProvider());
    }

    public InjectionValueProviderBuilder(IInjectionValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    <T> T get(Class<T> clazz) {
        return this.get(this.binding(clazz));
    }

    <T> T get(IBinding<T> binding) {
        if (this.results.containsKey(binding)) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(binding)) {
            return this.get(this.links.get(binding));
        }
        if (!this.services.containsKey(binding)) {
            return this.valueProvider.get(binding);
        }
        IValueHolder valueHolder = this.services.get(binding);
        if (!(valueHolder instanceof SingleValueHolder)) {
            throw new IllegalArgumentException();
        }
        return (T)((SingleValueHolder)valueHolder).getValue();
    }

    <T> Iterable<T> getAll(Class<T> clazz) {
        return this.getAll(this.binding(clazz));
    }

    <T> Iterable<T> getAll(IBinding<T> binding) {
        if (this.results.containsKey(binding)) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(binding)) {
            return this.getAll(this.links.get(binding));
        }
        if (!this.services.containsKey(binding)) {
            return this.valueProvider.getAll(binding);
        }
        IValueHolder valueHolder = this.services.get(binding);
        if (!(valueHolder instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        List values = ((ListValueHolder)valueHolder).getValue().stream().map(o -> o).collect(Collectors.toList());
        values.addAll(this.valueProvider.getAll(binding));
        return values;
    }

    private <T> IBinding<T> binding(Class<T> clazz) {
        return new ClassBinding<T>(clazz);
    }

    @Override
    public <T, S extends T> IInjectionValueProviderBuilder set(Class<T> clazz, S service) {
        return this.set(this.binding(clazz), service);
    }

    @Override
    public <T> IInjectionValueProviderBuilder set(Class<T> clazz, Class<? extends T> serviceClass) {
        return this.set(this.binding(clazz), serviceClass);
    }

    @Override
    public <T> IInjectionValueProviderBuilder set(Class<T> clazz, IInjectingFactory<T> objectFactory) {
        return this.set(this.binding(clazz), objectFactory);
    }

    @Override
    public <T> IInjectionValueProviderBuilder link(Class<T> clazz, Class<? extends T> link) {
        return this.link(this.binding(clazz), this.binding(link));
    }

    @Override
    public <T> IInjectionValueProviderBuilder add(Class<T> clazz, IInjectingFactory<T> objectFactory) {
        return this.add(this.binding(clazz), (Object)objectFactory);
    }

    @Override
    public <T> IInjectionValueProviderBuilder add(Class<T> clazz, Class<? extends T> serviceClass) {
        return this.add(this.binding(clazz), (Object)serviceClass);
    }

    @Override
    public <T, S extends T> IInjectionValueProviderBuilder add(Class<T> clazz, S service) {
        return this.add(this.binding(clazz), service);
    }

    @Override
    public <T> IInjectionValueProviderBuilder link(IBinding<T> binding, IBinding<? extends T> link) {
        if (!(this.results.containsKey(binding) || this.services.containsKey(binding) || this.valueProvider.contains(binding))) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(binding)) {
            throw new IllegalArgumentException();
        }
        if (this.results.containsKey(link) || this.services.containsKey(link) || this.valueProvider.contains(link)) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(link)) {
            throw new IllegalArgumentException();
        }
        this.links.put(link, binding);
        return this;
    }

    private <T> void checkSingleValue(IBinding<T> binding) {
        if (this.results.containsKey(binding) || this.services.containsKey(binding) || this.valueProvider.contains(binding)) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(binding)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public <T, S extends T> IInjectionValueProviderBuilder set(IBinding<T> clazz, S service) {
        this.checkSingleValue(clazz);
        this.services.put(clazz, new SingleValueHolder(service));
        return this;
    }

    @Override
    public <T> IInjectionValueProviderBuilder set(IBinding<T> binding, Class<? extends T> serviceClass) {
        this.checkSingleValue(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(serviceClass);
        this.results.put(binding, new SingleValueHolder(analyserResult));
        return this;
    }

    @Override
    public <T> IInjectionValueProviderBuilder set(IBinding<T> binding, IInjectingFactory<T> objectFactory) {
        this.checkSingleValue(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(objectFactory);
        this.results.put(binding, new SingleValueHolder(analyserResult));
        return this;
    }

    private <T> void checkListResult(IBinding<T> binding) {
        IValueHolder valueHolder;
        if (this.links.containsKey(binding)) {
            throw new IllegalArgumentException();
        }
        if (this.services.containsKey(binding) && !((valueHolder = this.services.get(binding)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        if (!this.results.containsKey(binding)) {
            this.results.put(binding, new ListValueHolder());
        }
        if (!((valueHolder = this.results.get(binding)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public <T> IInjectionValueProviderBuilder add(IBinding<T> binding, IInjectingFactory<T> objectFactory) {
        this.checkListResult(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(objectFactory);
        ((ListValueHolder)this.results.get(binding)).add(analyserResult);
        return this;
    }

    @Override
    public <T> IInjectionValueProviderBuilder add(IBinding<T> binding, Class<? extends T> serviceClass) {
        this.checkListResult(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(serviceClass);
        ((ListValueHolder)this.results.get(binding)).add(analyserResult);
        return this;
    }

    @Override
    public <T, S extends T> IInjectionValueProviderBuilder add(IBinding<T> binding, S service) {
        IValueHolder valueHolder;
        if (this.results.containsKey(binding) && !((valueHolder = this.results.get(binding)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        if (!this.services.containsKey(binding)) {
            this.services.put(binding, new ListValueHolder());
        }
        if (!((valueHolder = this.services.get(binding)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        ((ListValueHolder)this.services.get(binding)).add(service);
        return this;
    }

    private boolean isResolveable(IInjektionAnalyserResult analyserResult) {
        if (analyserResult.isIndependent()) {
            return true;
        }
        for (IBinding binding : analyserResult.getTypes()) {
            if (!this.services.containsKey(binding) && !this.valueProvider.contains(binding)) {
                if (this.results.containsKey(binding)) {
                    return false;
                }
                if (analyserResult.isNullable(binding) || analyserResult.isIterable(binding) && analyserResult.isEmptiable(binding)) continue;
                return false;
            }
            if (!this.results.containsKey(binding)) continue;
            if (analyserResult.isIterable(binding)) {
                return false;
            }
            throw new IllegalStateException("Found listvalue of type '" + binding + "' for singlevalue member of object '" + analyserResult.getType() + "'");
        }
        return true;
    }

    @Override
    public IInjectionValueProvider build() throws CreationException {
        InjektingObjectFactory factory = InjektingObjectFactory.create(this.valueProvider, this.services, this.links);
        int numberOfResults = 0;
        while (!this.results.isEmpty() && numberOfResults != this.results.size()) {
            HashSet<IBinding> keySet = new HashSet<IBinding>(this.results.keySet());
            numberOfResults = this.results.size();
            for (IBinding clazz : keySet) {
                IValueHolder valueHolder = this.results.get(clazz);
                if (valueHolder instanceof SingleValueHolder) {
                    IInjektionAnalyserResult result = (IInjektionAnalyserResult)((SingleValueHolder)valueHolder).getValue();
                    if (!this.isResolveable(result)) continue;
                    Object object = factory.create(result);
                    this.services.put(clazz, new SingleValueHolder(object));
                    this.results.remove(clazz);
                    continue;
                }
                if (!(valueHolder instanceof ListValueHolder)) continue;
                List<Object> analyserResults = ((ListValueHolder)valueHolder).getValue();
                if (!this.services.containsKey(clazz)) {
                    this.services.put(clazz, new ListValueHolder());
                }
                for (Object resultObject : analyserResults) {
                    IInjektionAnalyserResult result = (IInjektionAnalyserResult)resultObject;
                    if (!this.isResolveable(result)) continue;
                    Object object = factory.create(result);
                    ((ListValueHolder)this.services.get(clazz)).add(object);
                    ((ListValueHolder)valueHolder).remove(result);
                    if (!((ListValueHolder)valueHolder).isEmty()) continue;
                    this.results.remove(clazz);
                }
            }
        }
        if (!this.results.isEmpty()) {
            Optional<String> classes = this.results.keySet().stream().filter(v -> v != null).map(v -> this.createNotResolveMessage((IBinding)v)).sorted().reduce((i, v) -> i == null ? v : String.valueOf(i) + "\n" + v);
            throw new CreationException("Couldn't create objects for '" + classes.orElse("---") + "'");
        }
        return new InjectionValueProvider(this.valueProvider, new HashMap<IBinding, IValueHolder>(this.services), new HashMap<IBinding, IBinding>(this.links));
    }

    private String createNotResolveMessage(IBinding binding) {
        IValueHolder valueHolder = this.results.get(binding);
        StringBuilder builder = new StringBuilder();
        builder.append(binding);
        builder.append(" missing (");
        if (valueHolder instanceof SingleValueHolder) {
            IInjektionAnalyserResult result = (IInjektionAnalyserResult)((SingleValueHolder)valueHolder).getValue();
            if (!this.isResolveable(result)) {
                result.getTypes().forEach(b -> {
                    builder.append(b);
                    builder.append(" ");
                });
            }
            builder.append(")");
            return builder.toString();
        }
        if (valueHolder instanceof ListValueHolder) {
            List<Object> analyserResults = ((ListValueHolder)valueHolder).getValue();
            for (Object resultObject : analyserResults) {
                IInjektionAnalyserResult result = (IInjektionAnalyserResult)resultObject;
                if (this.isResolveable(result)) continue;
                result.getTypes().forEach(b -> {
                    builder.append(b);
                    builder.append(" ");
                });
            }
        }
        builder.append(")");
        return builder.toString();
    }
}

