/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.anwiba.commons.injection.IBinding;
import net.anwiba.commons.injection.IInjectionValueProvider;

public final class DefaultInjectionValueProvider
implements IInjectionValueProvider {
    private final HashMap<IBinding, List<Object>> values = new HashMap();

    public DefaultInjectionValueProvider() {
        this(new HashMap<IBinding, List<Object>>());
    }

    public DefaultInjectionValueProvider(Map<IBinding, List<Object>> values) {
        this.values.putAll(values);
    }

    @Override
    public boolean contains(IBinding<?> binding) {
        return this.values.containsKey(binding);
    }

    @Override
    public <T> T get(IBinding<T> binding) {
        List<Object> list = this.values.get(binding);
        if (list == null) {
            return null;
        }
        if (list.size() != 1) {
            throw new IllegalStateException();
        }
        return (T)list.get(0);
    }

    @Override
    public <T> Collection<T> getAll(IBinding<T> binding) {
        return Optional.ofNullable(this.values.get(binding)).map(l -> l.stream().map(o -> o).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
    }
}

