/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.anwiba.commons.injection.IBinding;
import net.anwiba.commons.injection.IInjectionValueProvider;
import net.anwiba.commons.injection.utilities.IValueHolder;
import net.anwiba.commons.injection.utilities.ListValueHolder;
import net.anwiba.commons.injection.utilities.SingleValueHolder;

public final class InjectionValueProvider
implements IInjectionValueProvider {
    private final Map<IBinding, IValueHolder> services;
    private final Map<IBinding, IBinding> links;
    private final IInjectionValueProvider valueProvider;

    public InjectionValueProvider(IInjectionValueProvider valueProvider, Map<IBinding, IValueHolder> services, Map<IBinding, IBinding> links) {
        this.valueProvider = valueProvider;
        this.services = services;
        this.links = links;
    }

    @Override
    public <T> Collection<T> getAll(IBinding<T> binding) {
        if (this.links.containsKey(binding)) {
            return this.getAll(this.links.get(binding));
        }
        IValueHolder holder = this.services.get(binding);
        if (holder == null) {
            return this.valueProvider.getAll(binding);
        }
        if (holder instanceof SingleValueHolder) {
            Object value = ((SingleValueHolder)holder).getValue();
            ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(value));
            values.addAll(this.valueProvider.getAll(binding));
            return values;
        }
        if (holder instanceof ListValueHolder) {
            List values = ((ListValueHolder)holder).getValue().stream().map(v -> v).collect(Collectors.toList());
            values.addAll(this.valueProvider.getAll(binding));
            return values;
        }
        throw new IllegalStateException();
    }

    @Override
    public <T> T get(IBinding<T> binding) {
        if (this.links.containsKey(binding)) {
            T object = this.get(this.links.get(binding));
            return object;
        }
        if (!this.services.containsKey(binding)) {
            return this.valueProvider.get(binding);
        }
        IValueHolder holder = this.services.get(binding);
        if (holder == null) {
            return null;
        }
        if (holder instanceof SingleValueHolder) {
            Object value = ((SingleValueHolder)holder).getValue();
            return (T)value;
        }
        throw new IllegalStateException("missing " + binding.getBoundedClass());
    }

    @Override
    public boolean contains(IBinding<?> binding) {
        if (this.links.containsKey(binding)) {
            IBinding link = this.links.get(binding);
            return this.services.containsKey(link) || this.valueProvider.contains(link);
        }
        return this.services.containsKey(binding) || this.valueProvider.contains(binding);
    }
}

