/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection.impl;

import java.util.Map;
import java.util.Objects;
import net.anwiba.commons.injection.IBinding;
import net.anwiba.commons.injection.IInjectionValueProvider;
import net.anwiba.commons.injection.binding.ClassBinding;
import net.anwiba.commons.injection.impl.IInjektionAnalyserResult;
import net.anwiba.commons.injection.impl.IResolveableForecaster;
import net.anwiba.commons.injection.impl.IValueInjectionAnalyser;
import net.anwiba.commons.injection.utilities.IValueHolder;

public class ResolveableForecaster
implements IResolveableForecaster {
    private final IInjectionValueProvider valueProvider;
    private final Map<IBinding, IValueHolder> services;
    private final Map<IBinding, IValueHolder> results;
    private final IValueInjectionAnalyser analyser;
    private final Map<IBinding, IBinding> links;

    public ResolveableForecaster(IInjectionValueProvider valueProvider, Map<IBinding, IValueHolder> services, Map<IBinding, IBinding> links, IValueInjectionAnalyser analyser, Map<IBinding, IValueHolder> results) {
        this.valueProvider = valueProvider;
        this.services = services;
        this.links = links;
        this.analyser = analyser;
        this.results = results;
    }

    @Override
    public boolean isResolveable(IInjektionAnalyserResult result) {
        if (Objects.equals(IInjektionAnalyserResult.UNRESOLVEABLE, result)) {
            return false;
        }
        if (result.isIndependent()) {
            return true;
        }
        for (IBinding binding : result.getBindings()) {
            if (!this.exists(binding)) {
                if (this.isDeclared(binding)) {
                    return false;
                }
                if (result.isIterable(binding)) {
                    if (result.isEmptiable(binding)) continue;
                    return false;
                }
                if (result.isNullable(binding) || result.isImitable(binding)) continue;
                if (!(binding instanceof ClassBinding) || this.links.containsKey(binding)) {
                    return false;
                }
                if (this.analyser.analyse(binding.getBoundedClass()).isIndependent()) continue;
                return false;
            }
            if (!this.isDeclared(binding)) continue;
            if (result.isIterable(binding)) {
                return false;
            }
            throw new IllegalStateException("Found listvalue of type '" + binding + "' for singlevalue member of object '" + result.getType() + "'");
        }
        return true;
    }

    private boolean isDeclared(IBinding binding) {
        return this.results.containsKey(binding) || this.links.containsKey(binding) && this.results.containsKey(this.links.get(binding));
    }

    private boolean exists(IBinding binding) {
        return this.links.containsKey(binding) && this.services.containsKey(this.links.get(binding)) || this.services.containsKey(binding) || this.valueProvider.contains(binding);
    }
}

