/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.anwiba.commons.annotation.Emptiable;
import net.anwiba.commons.injection.IBinding;
import net.anwiba.commons.injection.IInjectionValueProvider;
import net.anwiba.commons.injection.IValueInjector;
import net.anwiba.commons.injection.binding.ClassBinding;
import net.anwiba.commons.injection.impl.IInjektionAnalyserResult;
import net.anwiba.commons.injection.impl.IValueInjectionAnalyser;
import net.anwiba.commons.injection.impl.ImitateObjectProxyFactory;
import net.anwiba.commons.reflection.CreationException;

public abstract class AbstractTypeValueProvider<T extends AnnotatedElement> {
    private final IInjectionValueProvider valuesProvider;
    private final ImitateObjectProxyFactory imitateFactory;
    private final IValueInjectionAnalyser analyser;
    private final IValueInjector valueInjector;

    public AbstractTypeValueProvider(IValueInjectionAnalyser analyser, IValueInjector valueInjector, IInjectionValueProvider valuesProvider, ImitateObjectProxyFactory imitateFactory) {
        this.analyser = analyser;
        this.valueInjector = valueInjector;
        this.valuesProvider = valuesProvider;
        this.imitateFactory = imitateFactory;
    }

    protected abstract Class<?> getType(T var1);

    protected abstract IBinding createBinding(T var1);

    public Object getValue(T element) {
        Class<IValueInjector> type = this.getType(element);
        if (type.isAssignableFrom(IValueInjector.class)) {
            return this.valueInjector;
        }
        IBinding binding = this.createBinding(element);
        if (!this.valuesProvider.contains(binding)) {
            if (this.analyser.isNullable((AnnotatedElement)element)) {
                return null;
            }
            IInjektionAnalyserResult result = this.analyser.analyse(type);
            if (this.resolveable(result)) {
                try {
                    return this.valueInjector.create(type);
                }
                catch (CreationException exception) {
                    throw new IllegalStateException(exception.getMessage(), exception);
                }
            }
            if (this.analyser.isImitable((AnnotatedElement)element, type)) {
                try {
                    return this.imitateFactory.create(type);
                }
                catch (CreationException exception) {
                    throw new IllegalStateException(exception.getMessage(), exception);
                }
            }
        }
        if (this.isIterable(element, type)) {
            Collection value = this.valuesProvider.getAll(binding);
            if (value != null) {
                return value;
            }
            Emptiable emptiable = element.getAnnotation(Emptiable.class);
            if (emptiable != null && emptiable.value()) {
                return new ArrayList();
            }
            throw new IllegalStateException("missing injektion value for field '" + type + "'");
        }
        if (this.valuesProvider.contains(binding)) {
            return this.valuesProvider.get(binding);
        }
        throw new IllegalStateException("missing injektion value for field '" + type + "'");
    }

    protected abstract boolean isIterable(T var1, Class<?> var2);

    private boolean resolveable(IInjektionAnalyserResult result) {
        if (Objects.equals(IInjektionAnalyserResult.UNRESOLVEABLE, result)) {
            return false;
        }
        if (result.isIndependent()) {
            return true;
        }
        Iterable<IBinding> bindings = result.getBindings();
        for (IBinding binding : bindings) {
            if (this.valuesProvider.contains(binding)) continue;
            if (result.isIterable(binding)) {
                if (result.isEmptiable(binding)) continue;
                return false;
            }
            if (result.isNullable(binding) || result.isImitable(binding)) continue;
            if (!(binding instanceof ClassBinding)) {
                return false;
            }
            if (this.analyser.analyse(binding.getBoundedClass()).isIndependent()) continue;
            return false;
        }
        return true;
    }
}

