/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection.impl;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.anwiba.commons.injection.IBinding;
import net.anwiba.commons.injection.IInjectionValueProvider;
import net.anwiba.commons.injection.IValueInjector;
import net.anwiba.commons.injection.impl.AbstractTypeValueProvider;
import net.anwiba.commons.injection.impl.BindingFactory;
import net.anwiba.commons.injection.impl.IValueInjectionAnalyser;
import net.anwiba.commons.injection.impl.ImitateObjectProxyFactory;
import net.anwiba.commons.injection.impl.NameProvider;

public class FieldValueProvider
extends AbstractTypeValueProvider<Field> {
    private final BindingFactory bindingFactory;
    private final NameProvider nameProvider;

    public FieldValueProvider(IValueInjectionAnalyser analyser, IValueInjector valueInjector, IInjectionValueProvider valuesProvider, BindingFactory bindingFactory, NameProvider nameProvider, ImitateObjectProxyFactory imitateFactory) {
        super(analyser, valueInjector, valuesProvider, imitateFactory);
        this.bindingFactory = bindingFactory;
        this.nameProvider = nameProvider;
    }

    @Override
    protected IBinding createBinding(Field field) {
        Class<Iterable> clazz = field.getType();
        String name = this.nameProvider.getName(field, field.getName());
        if (clazz.isAssignableFrom(Iterable.class)) {
            Class<? extends Type> genericType = this.getIterableType(field);
            return this.bindingFactory.create(genericType, name);
        }
        return this.bindingFactory.create(clazz, name);
    }

    private Class<? extends Type> getIterableType(Field field) {
        if (ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        return field.getGenericType().getClass();
    }

    @Override
    protected Class<?> getType(Field field) {
        return field.getType();
    }

    @Override
    protected boolean isIterable(Field field, Class<?> type) {
        return Iterable.class.isAssignableFrom(type) && field.getGenericType() instanceof ParameterizedType;
    }
}

