/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.anwiba.commons.injection.DefaultInjectionValueProvider;
import net.anwiba.commons.injection.IBinding;
import net.anwiba.commons.injection.IBindingFactory;
import net.anwiba.commons.injection.IInjectingFactory;
import net.anwiba.commons.injection.IInjectingSupplier;
import net.anwiba.commons.injection.IInjectionValueProvider;
import net.anwiba.commons.injection.IInjectionValueProviderBuilder;
import net.anwiba.commons.injection.IScope;
import net.anwiba.commons.injection.impl.BindingFactory;
import net.anwiba.commons.injection.impl.IInjektionAnalyserResult;
import net.anwiba.commons.injection.impl.IResolveableForecaster;
import net.anwiba.commons.injection.impl.IValueInjectionAnalyser;
import net.anwiba.commons.injection.impl.InjectionValueProvider;
import net.anwiba.commons.injection.impl.InjektingObjectFactory;
import net.anwiba.commons.injection.impl.ResolveableForecaster;
import net.anwiba.commons.injection.impl.ValueInjectionAnalyser;
import net.anwiba.commons.injection.utilities.IValueHolder;
import net.anwiba.commons.injection.utilities.ListValueHolder;
import net.anwiba.commons.injection.utilities.SingleValueHolder;
import net.anwiba.commons.reflection.CreationException;

public class InjectionValueProviderBuilder
implements IInjectionValueProviderBuilder {
    private final IBindingFactory bindingFactory = new BindingFactory();
    private final IValueInjectionAnalyser analyser = new ValueInjectionAnalyser();
    private final Map<IBinding, IValueHolder> services = new HashMap<IBinding, IValueHolder>();
    private final Map<IBinding, IValueHolder> results = new HashMap<IBinding, IValueHolder>();
    private final Map<IBinding, IBinding> links = new HashMap<IBinding, IBinding>();
    private final IInjectionValueProvider valueProvider;
    private final IScope scope;

    public InjectionValueProviderBuilder(IScope scope) {
        this(scope, new DefaultInjectionValueProvider());
    }

    public InjectionValueProviderBuilder(IScope scope, IInjectionValueProvider valueProvider) {
        this.scope = scope;
        this.valueProvider = valueProvider;
    }

    private <T> IBinding<T> binding(Class<T> clazz) {
        return this.bindingFactory.create(clazz, null);
    }

    @Override
    public <T, S extends T> IInjectionValueProviderBuilder set(Class<T> clazz, S service) {
        return this.set(this.binding(clazz), service);
    }

    @Override
    public <T> IInjectionValueProviderBuilder set(Class<T> clazz) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        return this.set(clazz, clazz);
    }

    @Override
    public <T> IInjectionValueProviderBuilder set(Class<T> clazz, Class<? extends T> serviceClass) {
        return this.set(this.binding(clazz), serviceClass);
    }

    @Override
    public <T> IInjectionValueProviderBuilder set(Class<T> clazz, IInjectingFactory<T> objectFactory) {
        return this.set(this.binding(clazz), objectFactory);
    }

    @Override
    public <T, S extends IInjectingSupplier<T>> IInjectionValueProviderBuilder setBySupplier(Class<T> clazz, Class<S> supplierClass) {
        return this.setBySupplier(this.binding(clazz), supplierClass);
    }

    @Override
    public <T> IInjectionValueProviderBuilder link(Class<? extends T> clazz, Class<T> link) {
        return this.link(this.binding(clazz), this.binding(link));
    }

    @Override
    public <T, S extends IInjectingSupplier<T>> IInjectionValueProviderBuilder addBySupplier(Class<T> clazz, Class<S> supplierClass) {
        return this.addBySupplier(this.binding(clazz), supplierClass);
    }

    @Override
    public <T> IInjectionValueProviderBuilder add(Class<T> clazz, IInjectingFactory<T> objectFactory) {
        return this.add(this.binding(clazz), (Object)objectFactory);
    }

    @Override
    public <T> IInjectionValueProviderBuilder add(Class<T> clazz) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        return this.add(clazz, (Object)clazz);
    }

    @Override
    public <T> IInjectionValueProviderBuilder add(Class<T> clazz, Class<? extends T> serviceClass) {
        return this.add(this.binding(clazz), (Object)serviceClass);
    }

    @Override
    public <T, S extends T> IInjectionValueProviderBuilder add(Class<T> clazz, S service) {
        return this.add(this.binding(clazz), service);
    }

    @Override
    public <T> IInjectionValueProviderBuilder link(IBinding<? extends T> binding, IBinding<T> link) {
        if (!(this.results.containsKey(binding) || this.services.containsKey(binding) || this.valueProvider.contains(binding))) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(binding)) {
            throw new IllegalArgumentException();
        }
        if (this.results.containsKey(link) || this.services.containsKey(link) || this.valueProvider.contains(link)) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(link)) {
            throw new IllegalArgumentException();
        }
        this.links.put(link, binding);
        return this;
    }

    private <T> void checkSingleValue(IBinding<T> binding) {
        if (this.results.containsKey(binding) || this.services.containsKey(binding)) {
            throw new IllegalArgumentException("Scope: '" + this.scope + "', double registration of single value '" + binding.getBoundedClass().getName() + "'");
        }
        if (this.links.containsKey(binding)) {
            throw new IllegalArgumentException("Scope: '" + this.scope + "', double registration of single value '" + binding.getBoundedClass().getName() + "'");
        }
        if (this.valueProvider.contains(binding) && this.valueProvider.getAll(binding).size() > 1) {
            throw new IllegalArgumentException("Scope: '" + this.scope + "', double registration of single value '" + binding.getBoundedClass().getName() + "', can't overide list values");
        }
    }

    @Override
    public <T, S extends T> IInjectionValueProviderBuilder set(IBinding<T> clazz, S service) {
        this.checkSingleValue(clazz);
        this.services.put(clazz, new SingleValueHolder(service));
        return this;
    }

    @Override
    public <T> IInjectionValueProviderBuilder set(IBinding<T> binding, Class<? extends T> serviceClass) {
        this.checkSingleValue(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(serviceClass);
        this.results.put(binding, new SingleValueHolder(analyserResult));
        return this;
    }

    @Override
    public <T> IInjectionValueProviderBuilder set(IBinding<T> binding, IInjectingFactory<T> objectFactory) {
        this.checkSingleValue(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(objectFactory);
        this.results.put(binding, new SingleValueHolder(analyserResult));
        return this;
    }

    @Override
    public <T, S extends IInjectingSupplier<T>> IInjectionValueProviderBuilder setBySupplier(IBinding<T> binding, Class<S> supplierClass) {
        this.checkSingleValue(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(supplierClass);
        this.results.put(binding, new SingleValueHolder(analyserResult));
        return this;
    }

    private <T> void checkListResult(IBinding<T> binding) {
        IValueHolder valueHolder;
        if (this.links.containsKey(binding)) {
            throw new IllegalArgumentException();
        }
        if (this.services.containsKey(binding) && !((valueHolder = this.services.get(binding)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        if (!this.results.containsKey(binding)) {
            this.results.put(binding, new ListValueHolder());
        }
        if (!((valueHolder = this.results.get(binding)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public <T> IInjectionValueProviderBuilder add(IBinding<T> binding, IInjectingFactory<T> objectFactory) {
        this.checkListResult(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(objectFactory);
        ((ListValueHolder)this.results.get(binding)).add(analyserResult);
        return this;
    }

    @Override
    public <T> IInjectionValueProviderBuilder add(IBinding<T> binding, Class<? extends T> serviceClass) {
        this.checkListResult(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(serviceClass);
        ((ListValueHolder)this.results.get(binding)).add(analyserResult);
        return this;
    }

    @Override
    public <T, S extends IInjectingSupplier<T>> IInjectionValueProviderBuilder addBySupplier(IBinding<T> binding, Class<S> supplierClass) {
        this.checkListResult(binding);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(supplierClass);
        ((ListValueHolder)this.results.get(binding)).add(analyserResult);
        return this;
    }

    @Override
    public <T, S extends T> IInjectionValueProviderBuilder add(IBinding<T> binding, S service) {
        this.checkServiceListResult(binding);
        ((ListValueHolder)this.services.get(binding)).add(service);
        return this;
    }

    protected <T> void checkServiceListResult(IBinding<T> binding) {
        IValueHolder valueHolder;
        if (this.results.containsKey(binding) && !((valueHolder = this.results.get(binding)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        if (!this.services.containsKey(binding)) {
            this.services.put(binding, new ListValueHolder());
        }
        if (!((valueHolder = this.services.get(binding)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public IInjectionValueProvider build() throws CreationException {
        InjektingObjectFactory factory = InjektingObjectFactory.create(this.valueProvider, this.services, this.links);
        ResolveableForecaster forecaster = new ResolveableForecaster(this.valueProvider, this.services, this.links, this.analyser, this.results);
        int numberOfResults = 0;
        while (!this.results.isEmpty() && numberOfResults != this.results.size()) {
            HashSet<IBinding> keySet = new HashSet<IBinding>(this.results.keySet());
            numberOfResults = this.results.size();
            for (IBinding binding : keySet) {
                IValueHolder valueHolder = this.results.get(binding);
                if (valueHolder instanceof SingleValueHolder) {
                    IInjektionAnalyserResult result = (IInjektionAnalyserResult)((SingleValueHolder)valueHolder).getValue();
                    if (!forecaster.isResolveable(result)) continue;
                    Object object = factory.create(result);
                    if (object instanceof IInjectingSupplier) {
                        this.services.put(binding, new SingleValueHolder(((IInjectingSupplier)object).supply()));
                    } else {
                        this.services.put(binding, new SingleValueHolder(object));
                    }
                    this.results.remove(binding);
                    continue;
                }
                if (!(valueHolder instanceof ListValueHolder)) continue;
                List<Object> analyserResults = ((ListValueHolder)valueHolder).getValue();
                if (!this.services.containsKey(binding)) {
                    this.services.put(binding, new ListValueHolder());
                }
                for (Object resultObject : analyserResults) {
                    IInjektionAnalyserResult result = (IInjektionAnalyserResult)resultObject;
                    if (!forecaster.isResolveable(result)) continue;
                    Object object = factory.create(result);
                    if (object instanceof IInjectingSupplier) {
                        ((ListValueHolder)this.services.get(binding)).add(((IInjectingSupplier)object).supply());
                    } else {
                        ((ListValueHolder)this.services.get(binding)).add(object);
                    }
                    ((ListValueHolder)valueHolder).remove(result);
                    if (!((ListValueHolder)valueHolder).isEmty()) continue;
                    this.results.remove(binding);
                }
            }
        }
        if (!this.results.isEmpty()) {
            MissingBindingStringFactory stringFactory = new MissingBindingStringFactory(forecaster, this.results, this.services, this.links, this.valueProvider);
            Optional<String> classes = this.results.keySet().stream().filter(v -> v != null).map(v -> stringFactory.create((IBinding)v)).sorted().reduce((i, v) -> i == null ? v : i + "\n" + v);
            throw new CreationException("Scope: '" + this.scope + "', couldn't create objects for '" + classes.orElse("---") + "'");
        }
        return new InjectionValueProvider(this.valueProvider, new HashMap<IBinding, IValueHolder>(this.services), new HashMap<IBinding, IBinding>(this.links));
    }

    public static class MissingBindingStringFactory {
        private final Map<IBinding, IValueHolder> results;
        private final Map<IBinding, IValueHolder> services;
        private final Map<IBinding, IBinding> links;
        private final IInjectionValueProvider valueProvider;
        private final IResolveableForecaster forecaster;

        public MissingBindingStringFactory(IResolveableForecaster forecaster, Map<IBinding, IValueHolder> results, Map<IBinding, IValueHolder> services, Map<IBinding, IBinding> links, IInjectionValueProvider valueProvider) {
            this.forecaster = forecaster;
            this.results = results;
            this.services = services;
            this.links = links;
            this.valueProvider = valueProvider;
        }

        public String create(IBinding binding) {
            IValueHolder valueHolder = this.results.get(binding);
            StringBuilder builder = new StringBuilder();
            builder.append(binding);
            builder.append(" missing (");
            if (valueHolder instanceof SingleValueHolder) {
                IInjektionAnalyserResult result = (IInjektionAnalyserResult)((SingleValueHolder)valueHolder).getValue();
                this.addIfMissed(builder, result);
                builder.append(")");
                return builder.toString();
            }
            if (valueHolder instanceof ListValueHolder) {
                List<Object> analyserResults = ((ListValueHolder)valueHolder).getValue();
                for (Object resultObject : analyserResults) {
                    IInjektionAnalyserResult result = (IInjektionAnalyserResult)resultObject;
                    this.addIfMissed(builder, result);
                }
            }
            builder.append(")");
            return builder.toString();
        }

        private void addIfMissed(StringBuilder builder, IInjektionAnalyserResult result) {
            if (!this.forecaster.isResolveable(result)) {
                result.getBindings().forEach(b -> {
                    if (!this.contains((IBinding)b)) {
                        builder.append(b);
                        builder.append(" ");
                    }
                });
            }
        }

        boolean contains(IBinding binding) {
            return this.services.containsKey(binding) || this.links.containsKey(binding) && this.services.containsKey(this.links.get(binding)) || this.valueProvider.contains(binding);
        }
    }
}

