/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.anwiba.commons.annotation.Injection;
import net.anwiba.commons.injection.IInjectingFactory;
import net.anwiba.commons.injection.IInjectionValueProvider;
import net.anwiba.commons.injection.IValueInjector;
import net.anwiba.commons.injection.InjectionException;
import net.anwiba.commons.injection.impl.BindingFactory;
import net.anwiba.commons.injection.impl.FieldValueProvider;
import net.anwiba.commons.injection.impl.IValueInjectionAnalyser;
import net.anwiba.commons.injection.impl.ImitateObjectProxyFactory;
import net.anwiba.commons.injection.impl.InjectableConstructorsGetter;
import net.anwiba.commons.injection.impl.NameProvider;
import net.anwiba.commons.injection.impl.ParameterValuesProvider;
import net.anwiba.commons.injection.impl.ValueInjectionAnalyser;
import net.anwiba.commons.reflection.CreationException;
import net.anwiba.commons.reflection.ReflectionConstructorInvoker;
import net.anwiba.commons.reflection.ReflectionMethodInvoker;
import net.anwiba.commons.reflection.privileged.PrivilegedActionInvoker;
import net.anwiba.commons.reflection.privileged.PrivilegedFieldSetterAction;

public class ValueInjector
implements IValueInjector {
    private final InjectableConstructorsGetter injectableElementGetter = new InjectableConstructorsGetter();
    private final PrivilegedActionInvoker<Void> invoker = new PrivilegedActionInvoker(System.getSecurityManager());
    private final ImitateObjectProxyFactory imitateFactory = new ImitateObjectProxyFactory();
    private final ParameterValuesProvider parameterValuesProvider;
    private final FieldValueProvider fieldValueProvider;
    private final IValueInjectionAnalyser analyser = new ValueInjectionAnalyser();

    public ValueInjector(IInjectionValueProvider valuesProvider) {
        BindingFactory bindingFactory = new BindingFactory();
        NameProvider nameProvider = new NameProvider();
        this.parameterValuesProvider = new ParameterValuesProvider(this.analyser, this, valuesProvider, bindingFactory, nameProvider, this.imitateFactory);
        this.fieldValueProvider = new FieldValueProvider(this.analyser, this, valuesProvider, bindingFactory, nameProvider, this.imitateFactory);
    }

    @Override
    public <T> T create(IInjectingFactory<T> factory) throws CreationException {
        Method[] methods = factory.getClass().getMethods();
        List createMethods = Stream.of(methods).filter(m -> "create".equals(m.getName())).filter(m -> m.getAnnotation(Injection.class) != null).collect(Collectors.toList());
        if (createMethods.isEmpty()) {
            throw new CreationException("");
        }
        if (createMethods.size() > 1) {
            throw new CreationException("");
        }
        try {
            Method method = (Method)createMethods.get(0);
            Class[] parameterTypes = method.getParameterTypes();
            Class<?> factoryClass = factory.getClass();
            ReflectionMethodInvoker methodInvoker = new ReflectionMethodInvoker(factoryClass, "create", parameterTypes);
            Object[] methodValues = this.parameterValuesProvider.getValues(method.getParameters());
            return (T)methodInvoker.invoke(factory, methodValues);
        }
        catch (IllegalStateException exception) {
            throw new CreationException("Couldn't invoke method create instance of class '" + factory.getClass().getName() + "'", (Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            throw new CreationException("Couldn't invoke method create instance of class '" + factory.getClass().getName() + "'", exception.getCause());
        }
    }

    @Override
    public <T> T create(Class<T> clazz) throws CreationException {
        try {
            Constructor<T> constructor = this.injectableElementGetter.getConstructor(clazz);
            ReflectionConstructorInvoker constructorInvoker = new ReflectionConstructorInvoker(clazz, (Class[])constructor.getParameterTypes());
            Object[] constructorValues = this.parameterValuesProvider.getValues(constructor.getParameters());
            Object object = constructorInvoker.invoke(constructorValues);
            this.inject(object);
            return (T)object;
        }
        catch (InvocationTargetException exception) {
            throw new CreationException("Couldn't create instance for class '" + clazz.getName() + "'", exception.getCause());
        }
        catch (IllegalArgumentException | IllegalStateException | InjectionException exception) {
            throw new CreationException("Couldn't create instance for class '" + clazz.getName() + "', " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public <T> void inject(T object) throws InjectionException {
        Field[] fieldArray;
        Class<?> clazz = object.getClass();
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            this.inject(object, field);
        }
    }

    private <T> void inject(T object, Field field) throws InjectionException {
        try {
            this.setValue(field, object);
        }
        catch (InvocationTargetException exception) {
            throw new InjectionException("Couldn't inject value to field '" + field.getName() + "' of class '" + object.getClass().getName() + "'", exception.getCause());
        }
        catch (IllegalStateException exception) {
            throw new InjectionException("Couldn't inject value to field '" + field.getName() + "' of class '" + object.getClass().getName() + "'", exception);
        }
    }

    private <T> void setValue(Field field, T object) throws InvocationTargetException {
        if (!this.analyser.isInjectable(field)) {
            return;
        }
        Object value = this.fieldValueProvider.getValue(field);
        this.invoker.invoke((PrivilegedAction)new PrivilegedFieldSetterAction(object, field.getName(), value));
    }
}

