/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import net.anwiba.commons.annotation.Injection;

public final class InjectableConstructorsGetter {
    public <T> Constructor<T> getConstructor(Class<T> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        if (constructors.length > 1) {
            for (Constructor<?> constructor : constructors) {
                if (!this.isInjectable(constructor)) continue;
                return constructor;
            }
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterCount() != 0) continue;
                return constructor;
            }
            return null;
        }
        return constructors[0];
    }

    private boolean isInjectable(AnnotatedElement element) {
        Injection annotation = element.getAnnotation(Injection.class);
        return annotation != null && annotation.value();
    }
}

