/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection.impl;

import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.anwiba.commons.injection.IBinding;
import net.anwiba.commons.injection.IInjectionValueProvider;
import net.anwiba.commons.injection.IValueInjector;
import net.anwiba.commons.injection.impl.AbstractTypeValueProvider;
import net.anwiba.commons.injection.impl.BindingFactory;
import net.anwiba.commons.injection.impl.IValueInjectionAnalyser;
import net.anwiba.commons.injection.impl.ImitateObjectProxyFactory;
import net.anwiba.commons.injection.impl.NameProvider;

public class ParameterValuesProvider
extends AbstractTypeValueProvider<Parameter> {
    private final BindingFactory bindingFactory;
    private final NameProvider nameProvider;

    public ParameterValuesProvider(IValueInjectionAnalyser analyser, IValueInjector valueInjector, IInjectionValueProvider valuesProvider, BindingFactory bindingFactory, NameProvider nameProvider, ImitateObjectProxyFactory imitateFactory) {
        super(analyser, valueInjector, valuesProvider, imitateFactory);
        this.bindingFactory = bindingFactory;
        this.nameProvider = nameProvider;
    }

    public Object[] getValues(Parameter[] parameters) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Parameter parameter : parameters) {
            result.add(this.getValue(parameter));
        }
        return result.toArray(new Object[result.size()]);
    }

    @Override
    protected IBinding createBinding(Parameter parameter) {
        Class<?> clazz = parameter.getType();
        String name = this.nameProvider.getName(parameter, parameter.getName());
        if (Iterable.class.isAssignableFrom(clazz) && parameter.getParameterizedType() instanceof ParameterizedType) {
            Class<? extends Type> genericType = this.getIterableType(parameter);
            return this.bindingFactory.create(genericType, name);
        }
        return this.bindingFactory.create(clazz, name);
    }

    private Class<? extends Type> getIterableType(Parameter parameter) {
        Type type = parameter.getParameterizedType();
        if (type instanceof Class) {
            return (Class)type;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }

    @Override
    protected Class<?> getType(Parameter parameter) {
        return parameter.getType();
    }

    @Override
    protected boolean isIterable(Parameter parameter, Class<?> type) {
        return Iterable.class.isAssignableFrom(type) && parameter.getParameterizedType() instanceof ParameterizedType;
    }
}

