/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.injection.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.anwiba.commons.annotation.Emptiable;
import net.anwiba.commons.annotation.Imitable;
import net.anwiba.commons.annotation.Injection;
import net.anwiba.commons.annotation.Nullable;
import net.anwiba.commons.injection.IBinding;
import net.anwiba.commons.injection.IInjectingFactory;
import net.anwiba.commons.injection.binding.ClassBinding;
import net.anwiba.commons.injection.binding.NamedClassBinding;
import net.anwiba.commons.injection.impl.IInjektionAnalyserResult;
import net.anwiba.commons.injection.impl.IInjektionAnalyserValueResult;
import net.anwiba.commons.injection.impl.IValueInjectionAnalyser;
import net.anwiba.commons.injection.impl.InjectableConstructorsGetter;
import net.anwiba.commons.injection.impl.InjektionAnalyserResult;
import net.anwiba.commons.injection.impl.InjektionAnalyserValueResult;
import net.anwiba.commons.injection.impl.NameProvider;

public class ValueInjectionAnalyser
implements IValueInjectionAnalyser {
    private final InjectableConstructorsGetter injectableElementGetter = new InjectableConstructorsGetter();
    private final NameProvider nameProvider = new NameProvider();

    @Override
    public <T> IInjektionAnalyserResult analyse(IInjectingFactory<T> factory) {
        String createMethodName = "create";
        Method[] methods = factory.getClass().getMethods();
        List createMethods = Stream.of(methods).filter(m -> "create".equals(m.getName())).filter(m -> m.getAnnotation(Injection.class) != null).collect(Collectors.toList());
        if (createMethods.size() != 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<IInjektionAnalyserValueResult> results = new ArrayList<IInjektionAnalyserValueResult>();
        Method method = (Method)createMethods.get(0);
        for (Parameter parameter : method.getParameters()) {
            results.add(this.analyse(parameter));
        }
        try {
            Class<?> clazz = method.getReturnType();
            return InjektionAnalyserResult.create(clazz, results, factory);
        }
        catch (ClassCastException exception) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public <T> IInjektionAnalyserResult analyse(Class<T> clazz) {
        try {
            Field[] fieldArray = clazz.getDeclaredFields();
            Constructor<T> constructor = this.injectableElementGetter.getConstructor(clazz);
            if (constructor == null) {
                return IInjektionAnalyserResult.UNRESOLVEABLE;
            }
            ArrayList<IInjektionAnalyserValueResult> results = new ArrayList<IInjektionAnalyserValueResult>();
            for (Parameter parameter : constructor.getParameters()) {
                results.add(this.analyse(parameter));
            }
            for (AnnotatedElement annotatedElement : fieldArray) {
                if (!this.isInjectable(annotatedElement)) continue;
                results.add(this.analyse((Field)annotatedElement));
            }
            return InjektionAnalyserResult.create(clazz, results);
        }
        catch (IllegalStateException exception) {
            throw new IllegalStateException(clazz.getName() + ", " + exception.getMessage(), exception);
        }
    }

    private IInjektionAnalyserValueResult analyse(Parameter parameter) {
        boolean isNullable = this.isNullable(parameter);
        Class type = this.getType(parameter);
        boolean isImitable = this.isImitable(parameter, type);
        boolean isIterable = this.isIterable(type) && parameter.getParameterizedType() instanceof ParameterizedType;
        String name = this.nameProvider.getName(parameter, null);
        if (isIterable) {
            Class<? extends Type> iterableType = this.getIterableType(parameter);
            boolean isEmptiable = this.isEmptiable(parameter);
            return new InjektionAnalyserValueResult(this.binding(iterableType, name), isNullable, isImitable, isIterable, isEmptiable);
        }
        return new InjektionAnalyserValueResult(this.binding(type, name), isNullable, isImitable, isIterable, false);
    }

    private IInjektionAnalyserValueResult analyse(Field field) {
        boolean isNullable = this.isNullable(field);
        Class type = this.getType(field);
        boolean isImitable = this.isImitable(field, type) && field.getGenericType() instanceof ParameterizedType;
        String name = this.nameProvider.getName(field, field.getName());
        boolean isIterable = this.isIterable(type);
        if (isIterable) {
            Class<? extends Type> iterableType = this.getIterableType(field);
            boolean isEmptiable = this.isEmptiable(field);
            return new InjektionAnalyserValueResult(this.binding(iterableType, name), isNullable, isImitable, isIterable, isEmptiable);
        }
        return new InjektionAnalyserValueResult(this.binding(type, name), isNullable, isImitable, isIterable, false);
    }

    private <T> IBinding<T> binding(Class<T> clazz, String name) {
        return Optional.ofNullable(name).map(n -> new NamedClassBinding(clazz, (String)n)).orElseGet(() -> new ClassBinding(clazz));
    }

    private boolean isIterable(Class type) {
        return Iterable.class.isAssignableFrom(type);
    }

    private Class getType(Parameter parameter) {
        return parameter.getType();
    }

    private Class getType(Field field) {
        return field.getType();
    }

    @Override
    public boolean isNullable(AnnotatedElement element) {
        Nullable annotation = element.getAnnotation(Nullable.class);
        return annotation != null && annotation.value();
    }

    private boolean isEmptiable(AnnotatedElement element) {
        Emptiable annotation = element.getAnnotation(Emptiable.class);
        return annotation != null && annotation.value();
    }

    @Override
    public boolean isImitable(AnnotatedElement element, Class type) {
        Method[] methods;
        if (!type.isInterface()) {
            return false;
        }
        for (Method method : methods = type.getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (Void.class.equals(returnType) || Void.TYPE.equals(returnType) || method.isDefault()) continue;
            return false;
        }
        Imitable annotation = element.getAnnotation(Imitable.class);
        return annotation != null && annotation.value();
    }

    private Class<? extends Type> getIterableType(Field field) {
        if (ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        return field.getGenericType().getClass();
    }

    private Class<? extends Type> getIterableType(Parameter parameter) {
        Type type = parameter.getParameterizedType();
        if (type instanceof Class) {
            return (Class)type;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }

    @Override
    public boolean isInjectable(AnnotatedElement element) {
        Injection annotation = element.getAnnotation(Injection.class);
        return annotation != null && annotation.value();
    }
}

