/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.name;

import net.anwiba.commons.jdbc.name.IDatabaseConstraintName;
import net.anwiba.commons.jdbc.name.IDatabaseTriggerName;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class DatabaseConstraintName
implements IDatabaseConstraintName {
    private final String catalogName;
    private final String schemaName;
    private final String constraintName;

    public DatabaseConstraintName(String schemaName, String constraintName) {
        this(null, schemaName, constraintName);
    }

    public DatabaseConstraintName(String constraintName) {
        this(null, null, constraintName);
    }

    public DatabaseConstraintName(String catalogName, String schemaName, String constraintName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.constraintName = constraintName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }

    public int hashCode() {
        int result = 31 + (this.catalogName == null ? 0 : this.catalogName.hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        return 31 * result + (this.constraintName == null ? 0 : this.constraintName.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IDatabaseTriggerName)) {
            return false;
        }
        IDatabaseTriggerName other = (IDatabaseTriggerName)obj;
        return ObjectUtilities.equals((Object)this.catalogName, (Object)other.getCatalogName()) && ObjectUtilities.equals((Object)this.schemaName, (Object)other.getSchemaName()) && ObjectUtilities.equals((Object)this.constraintName, (Object)other.getTriggerName());
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder();
        if (!StringUtilities.isNullOrEmpty((String)this.catalogName)) {
            builder.append(this.catalogName);
            builder.append(".");
        }
        if (!StringUtilities.isNullOrEmpty((String)this.schemaName)) {
            builder.append(this.schemaName);
            builder.append(".");
        }
        builder.append(this.constraintName);
        return builder.toString();
    }
}

