/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.software;

import java.sql.Driver;
import java.util.Arrays;
import java.util.List;
import net.anwiba.commons.jdbc.DatabaseUtilities;
import net.anwiba.commons.jdbc.software.IDatabaseSoftware;
import net.anwiba.commons.jdbc.software.IJdbcPattern;
import net.anwiba.commons.jdbc.software.JdbcPattern;

public enum FileDatabaseSoftware implements IDatabaseSoftware
{
    DERBY("org.sqlite.JDBC", "jdbc:derby:memory", 0, "${protocol}:${database};create=true", "java.lang.Object"){}
    ,
    SQLITE("org.sqlite.JDBC", "jdbc:sqlite", 0, "${protocol}:${database}", "java.lang.Object"){};

    private transient Driver driver;
    private final String protocol;
    private final int port;
    private final String geometryClassName;
    private final String driverName;
    private IJdbcPattern jdbcPattern;

    private FileDatabaseSoftware(String driverName, String protocol, int port, String jdbcUrlPattern, String geometryClassName) {
        this.driverName = driverName;
        this.driver = DatabaseUtilities.loadDriver(driverName);
        this.protocol = protocol;
        this.port = port;
        this.geometryClassName = geometryClassName;
        this.jdbcPattern = new JdbcPattern(this.getDefaultJdbcUrlPatternName(), jdbcUrlPattern);
    }

    @Override
    public Driver getDriver() {
        if (this.driver == null) {
            Driver _driver;
            this.driver = _driver = DatabaseUtilities.loadDriver(this.driverName);
        }
        return this.driver;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isApplicable() {
        return this.getDriver() != null;
    }

    @Override
    public boolean isGisSupportApplicable() {
        try {
            Class.forName(this.geometryClassName);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static FileDatabaseSoftware getByUrl(String url) {
        FileDatabaseSoftware[] values;
        if (url == null) {
            return null;
        }
        FileDatabaseSoftware[] fileDatabaseSoftwareArray = values = FileDatabaseSoftware.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            FileDatabaseSoftware serviceDatabaseSoftware = fileDatabaseSoftwareArray[n2];
            if (url.toLowerCase().startsWith(serviceDatabaseSoftware.getProtocol())) {
                return serviceDatabaseSoftware;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getDefaultJdbcUrlPatternName() {
        return "default";
    }

    @Override
    public IJdbcPattern getJdbcUrlPattern(String name) {
        return this.jdbcPattern;
    }

    public static FileDatabaseSoftware getByDriverNamw(String driverName) {
        FileDatabaseSoftware[] values;
        if (driverName == null) {
            return null;
        }
        FileDatabaseSoftware[] fileDatabaseSoftwareArray = values = FileDatabaseSoftware.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            FileDatabaseSoftware serviceDatabaseSoftware = fileDatabaseSoftwareArray[n2];
            if (driverName.equals(serviceDatabaseSoftware.getDriverName())) {
                return serviceDatabaseSoftware;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public List<IJdbcPattern> getJdbcUrlPatterns() {
        return Arrays.asList(this.jdbcPattern);
    }

    /* synthetic */ FileDatabaseSoftware(String string, int n, String string2, String string3, int n2, String string4, String string5, FileDatabaseSoftware fileDatabaseSoftware) {
        this(string2, string3, n2, string4, string5);
    }
}

