/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.software;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.jdbc.DatabaseUtilities;
import net.anwiba.commons.jdbc.software.IDatabaseSoftware;
import net.anwiba.commons.jdbc.software.IDatabaseSoftwareVisitor;
import net.anwiba.commons.jdbc.software.IJdbcPattern;
import net.anwiba.commons.jdbc.software.JdbcPattern;

public enum ServiceDatabaseSoftware implements IDatabaseSoftware
{
    ORACLE("oracle.jdbc.OracleDriver", "jdbc:oracle:thin", 1521, "sid", (Map)ServiceDatabaseSoftware.createJdbcUrlPatterns(Arrays.asList("sid", "service"), Arrays.asList("${protocol}:@${host}:${port}:${database}", "${protocol}:@//${host}:${port}/${database}")), "oracle.spatial.geometry.JGeometry"){

        @Override
        public <T, E extends Exception> T accept(IDatabaseSoftwareVisitor<T, E> visitor) throws E {
            return visitor.visitOracle();
        }
    }
    ,
    POSTGRES("org.postgresql.Driver", "jdbc:postgresql", 5432, "default", (Map)ServiceDatabaseSoftware.createJdbcUrlPatterns(Arrays.asList("default"), Arrays.asList("${protocol}://${host}:${port}/${database}")), "org.postgis.Geometry"){

        @Override
        public <T, E extends Exception> T accept(IDatabaseSoftwareVisitor<T, E> visitor) throws E {
            return visitor.visitPostgres();
        }
    }
    ,
    HANA("com.sap.db.jdbc.Driver", "jdbc:sap", 30015, "default", (Map)ServiceDatabaseSoftware.createJdbcUrlPatterns(Arrays.asList("default"), Arrays.asList("${protocol}://${host}:${port}")), "java.lang.Object"){

        @Override
        public <T, E extends Exception> T accept(IDatabaseSoftwareVisitor<T, E> visitor) throws E {
            return visitor.visitHana();
        }
    };

    private transient Driver driver;
    private final Map<String, IJdbcPattern> jdbcUrlPatterns = new HashMap<String, IJdbcPattern>();
    private final String protocol;
    private final int port;
    private final String geometryClassName;
    private final String driverName;
    private final String defaultJdbcUrlPatternName;

    static Map<String, IJdbcPattern> createJdbcUrlPatterns(List<String> names, List<String> patterns) {
        HashMap<String, IJdbcPattern> jdbcUrlPatterns = new HashMap<String, IJdbcPattern>();
        int i = 0;
        while (i < names.size()) {
            jdbcUrlPatterns.put(names.get(i), new JdbcPattern(names.get(i), patterns.get(i)));
            ++i;
        }
        return jdbcUrlPatterns;
    }

    private ServiceDatabaseSoftware(String driverName, String protocol, int port, String defaultJdbcUrlPatternName, Map<String, IJdbcPattern> jdbcUrlPatterns, String geometryClassName) {
        this.driverName = driverName;
        this.defaultJdbcUrlPatternName = defaultJdbcUrlPatternName;
        this.jdbcUrlPatterns.putAll(jdbcUrlPatterns);
        this.driver = DatabaseUtilities.loadDriver(driverName);
        this.protocol = protocol;
        this.port = port;
        this.geometryClassName = geometryClassName;
    }

    @Override
    public Driver getDriver() {
        if (this.driver == null) {
            Driver _driver;
            this.driver = _driver = DatabaseUtilities.loadDriver(this.driverName);
        }
        return this.driver;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public abstract <T, E extends Exception> T accept(IDatabaseSoftwareVisitor<T, E> var1) throws E;

    @Override
    public boolean isApplicable() {
        return this.getDriver() != null;
    }

    @Override
    public boolean isGisSupportApplicable() {
        try {
            Class.forName(this.geometryClassName);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static ServiceDatabaseSoftware getByUrl(String url) {
        ServiceDatabaseSoftware[] values;
        if (url == null) {
            return null;
        }
        ServiceDatabaseSoftware[] serviceDatabaseSoftwareArray = values = ServiceDatabaseSoftware.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceDatabaseSoftware serviceDatabaseSoftware = serviceDatabaseSoftwareArray[n2];
            if (url.toLowerCase().startsWith(serviceDatabaseSoftware.getProtocol())) {
                return serviceDatabaseSoftware;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getDefaultJdbcUrlPatternName() {
        return this.defaultJdbcUrlPatternName;
    }

    @Override
    public IJdbcPattern getJdbcUrlPattern(String name) {
        return this.jdbcUrlPatterns.get(name);
    }

    @Override
    public List<IJdbcPattern> getJdbcUrlPatterns() {
        return new ArrayList<IJdbcPattern>(this.jdbcUrlPatterns.values());
    }

    /* synthetic */ ServiceDatabaseSoftware(String string, int n, String string2, String string3, int n2, String string4, Map map, String string5, ServiceDatabaseSoftware serviceDatabaseSoftware) {
        this(string2, string3, n2, string4, map, string5);
    }
}

