/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.name;

import net.anwiba.commons.jdbc.name.IDatabaseSequenceName;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class DatabaseSequenceName
implements IDatabaseSequenceName {
    private static final long serialVersionUID = 1L;
    private final String catalogName;
    private final String schemaName;
    private final String sequenceName;

    public DatabaseSequenceName(String schemaName, String sequenceName) {
        this(null, schemaName, sequenceName);
    }

    public DatabaseSequenceName(String tableName) {
        this(null, null, tableName);
    }

    public DatabaseSequenceName(String catalogName, String schemaName, String sequenceName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.sequenceName = sequenceName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    public int hashCode() {
        int result = 31 + (this.catalogName == null ? 0 : this.catalogName.hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        return 31 * result + (this.sequenceName == null ? 0 : this.sequenceName.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IDatabaseSequenceName)) {
            return false;
        }
        IDatabaseSequenceName other = (IDatabaseSequenceName)obj;
        return ObjectUtilities.equals((Object)this.catalogName, (Object)other.getCatalogName()) && ObjectUtilities.equals((Object)this.schemaName, (Object)other.getSchemaName()) && ObjectUtilities.equals((Object)this.sequenceName, (Object)other.getSequenceName());
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder();
        if (!StringUtilities.isNullOrEmpty((String)this.catalogName)) {
            builder.append(this.catalogName);
            builder.append(".");
        }
        if (!StringUtilities.isNullOrEmpty((String)this.schemaName)) {
            builder.append(this.schemaName);
            builder.append(".");
        }
        builder.append(this.sequenceName);
        return builder.toString();
    }
}

