/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.name;

import net.anwiba.commons.jdbc.name.IDatabaseTriggerName;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class DatabaseTriggerName
implements IDatabaseTriggerName {
    private static final long serialVersionUID = 1L;
    private final String catalogName;
    private final String schemaName;
    private final String triggerName;

    public DatabaseTriggerName(String schemaName, String triggerName) {
        this(null, schemaName, triggerName);
    }

    public DatabaseTriggerName(String triggerName) {
        this(null, null, triggerName);
    }

    public DatabaseTriggerName(String catalogName, String schemaName, String triggerName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.triggerName = triggerName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getTriggerName() {
        return this.triggerName;
    }

    public int hashCode() {
        int result = 31 + (this.catalogName == null ? 0 : this.catalogName.hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        return 31 * result + (this.triggerName == null ? 0 : this.triggerName.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IDatabaseTriggerName)) {
            return false;
        }
        IDatabaseTriggerName other = (IDatabaseTriggerName)obj;
        return ObjectUtilities.equals((Object)this.catalogName, (Object)other.getCatalogName()) && ObjectUtilities.equals((Object)this.schemaName, (Object)other.getSchemaName()) && ObjectUtilities.equals((Object)this.triggerName, (Object)other.getTriggerName());
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder();
        if (!StringUtilities.isNullOrEmpty((String)this.catalogName)) {
            builder.append(this.catalogName);
            builder.append(".");
        }
        if (!StringUtilities.isNullOrEmpty((String)this.schemaName)) {
            builder.append(this.schemaName);
            builder.append(".");
        }
        builder.append(this.triggerName);
        return builder.toString();
    }
}

