/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.result;

import java.io.InputStream;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;
import net.anwiba.commons.jdbc.result.IResult;

public class ResultSetToResultAdapter
implements IResult {
    private final ResultSet resultSet;

    public ResultSetToResultAdapter(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.resultSet.getString(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.resultSet.getString(columnName);
    }

    @Override
    public Boolean getBoolean(int columnIndex) throws SQLException {
        boolean value = this.resultSet.getBoolean(columnIndex);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public boolean getBoolean(int columnIndex, boolean nullValue) throws SQLException {
        boolean value = this.resultSet.getBoolean(columnIndex);
        if (this.resultSet.wasNull()) {
            return nullValue;
        }
        return value;
    }

    @Override
    public Byte getByte(int columnIndex) throws SQLException {
        byte value = this.resultSet.getByte(columnIndex);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public byte getByte(int columnIndex, byte nullValue) throws SQLException {
        byte value = this.resultSet.getByte(columnIndex);
        if (this.resultSet.wasNull()) {
            return nullValue;
        }
        return value;
    }

    @Override
    public Short getShort(int columnIndex) throws SQLException {
        short value = this.resultSet.getShort(columnIndex);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public short getShort(int columnIndex, short nullValue) throws SQLException {
        short value = this.resultSet.getShort(columnIndex);
        if (this.resultSet.wasNull()) {
            return nullValue;
        }
        return value;
    }

    @Override
    public Integer getInteger(int columnIndex) throws SQLException {
        int value = this.resultSet.getInt(columnIndex);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public int getInteger(int columnIndex, int nullValue) throws SQLException {
        int value = this.resultSet.getInt(columnIndex);
        if (this.resultSet.wasNull()) {
            return nullValue;
        }
        return value;
    }

    @Override
    public Long getLong(int columnIndex) throws SQLException {
        long value = this.resultSet.getLong(columnIndex);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public long getLong(int columnIndex, int nullValue) throws SQLException {
        long value = this.resultSet.getLong(columnIndex);
        if (this.resultSet.wasNull()) {
            return nullValue;
        }
        return value;
    }

    @Override
    public Float getFloat(int columnIndex) throws SQLException {
        float value = this.resultSet.getFloat(columnIndex);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return Float.valueOf(value);
    }

    @Override
    public float getFloat(int columnIndex, float nullValue) throws SQLException {
        float value = this.resultSet.getFloat(columnIndex);
        if (this.resultSet.wasNull()) {
            return nullValue;
        }
        return value;
    }

    @Override
    public Double getDouble(int columnIndex) throws SQLException {
        double value = this.resultSet.getDouble(columnIndex);
        if (this.resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public double getDouble(int columnIndex, double nullValue) throws SQLException {
        double value = this.resultSet.getDouble(columnIndex);
        if (this.resultSet.wasNull()) {
            return nullValue;
        }
        return value;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultSet.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.resultSet.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.resultSet.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.resultSet.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.resultSet.getBinaryStream(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.resultSet.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.resultSet.getObject(columnName);
    }

    @Override
    public int getNumberOfValues() throws SQLException {
        return this.resultSet.getMetaData().getColumnCount();
    }

    @Override
    public boolean hasColumn(String columnName) throws SQLException {
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            if (Objects.equals(metaData.getColumnName(i + 1), columnName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

