/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.anwiba.commons.jdbc.connection.IRegisterableDatabaseConnector;

public class DefaultDatabaseConnector
implements IRegisterableDatabaseConnector {
    private static final int TIMEOUT = 10;

    @Override
    public synchronized Connection connectReadOnly(String url, String userName, String password, int timeout) throws SQLException {
        return this.connect(url, userName, password, timeout, true);
    }

    @Override
    public Connection connectWritable(String url, String userName, String password, int timeout) throws SQLException {
        return this.connect(url, userName, password, timeout, false);
    }

    public synchronized Connection connect(String url, String userName, String password, int timeout, boolean isReadOnly) throws SQLException {
        if (timeout == -1) {
            return this.createConnection(url, userName, password, isReadOnly);
        }
        int loginTimeout = DriverManager.getLoginTimeout();
        try {
            DriverManager.setLoginTimeout(timeout);
            Connection connection = this.createConnection(url, userName, password, isReadOnly);
            return connection;
        }
        finally {
            DriverManager.setLoginTimeout(loginTimeout);
        }
    }

    private Connection createConnection(String url, String user, String password, boolean isReadOnly) throws SQLException {
        Connection connection = DriverManager.getConnection(url, user, password);
        connection.setReadOnly(isReadOnly);
        return connection;
    }

    public boolean isApplicable(String context) {
        return true;
    }

    @Override
    public boolean isConnectable(String url, String userName, String password) {
        Throwable throwable = null;
        Object var5_6 = null;
        Connection connection = this.connectReadOnly(url, userName, password, 10);
        if (connection != null) {
            connection.close();
        }
        try {
            return true;
        }
        catch (Throwable throwable2) {
            try {
                if (connection != null) {
                    connection.close();
                }
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    return false;
                }
            }
        }
    }
}

