/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.constraint;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.jdbc.constraint.Constraint;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public class ConstraintsUtilities {
    public static boolean isPrimaryKey(Map<String, Constraint> constraints, String columnName) {
        for (Constraint constraint : constraints.values()) {
            if (!constraint.isPrimaryKey() || !constraint.contains(columnName)) continue;
            return true;
        }
        return false;
    }

    public static Constraint[] getColumnConstaints(final String columnName, Map<String, Constraint> constraints) {
        List columnConstraints = IterableUtilities.asList(constraints.values(), (IAcceptor)new IAcceptor<Constraint>(){

            public boolean accept(Constraint constraint) {
                return constraint.contains(columnName);
            }
        });
        return columnConstraints.toArray(new Constraint[columnConstraints.size()]);
    }

    public static boolean containsBooleanConstraints(final String name, Constraint[] constraints) {
        return IterableUtilities.containsAcceptedItems(Arrays.asList(constraints), (IAcceptor)new IAcceptor<Constraint>(){

            public boolean accept(Constraint constraint) {
                return constraint.getCondition() != null && constraint.getCondition().equals(String.valueOf(name) + " IN (0,1)");
            }
        });
    }
}

