/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.name;

import net.anwiba.commons.jdbc.name.DatabaseTableName;
import net.anwiba.commons.jdbc.name.IDatabaseColumnName;
import net.anwiba.commons.jdbc.name.IDatabaseTableName;

public class DatabaseColumnName
implements IDatabaseColumnName {
    private final IDatabaseTableName table;
    private final String columnName;

    public DatabaseColumnName(IDatabaseTableName table, String columnName) {
        this.table = table;
        this.columnName = columnName;
    }

    public DatabaseColumnName(String schemaName, String tableName, String columnName) {
        this(new DatabaseTableName(schemaName, tableName), columnName);
    }

    @Override
    public IDatabaseTableName getDatabaseTable() {
        return this.table;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getName() {
        return String.valueOf(this.table.getName()) + "." + this.columnName;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getTableName() {
        return this.table.getTableName();
    }

    @Override
    public String getSchemaName() {
        return this.table.getSchemaName();
    }
}

