/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.name;

import net.anwiba.commons.jdbc.name.IDatabaseIndexName;
import net.anwiba.commons.jdbc.name.IDatabaseTriggerName;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class DatabaseIndexName
implements IDatabaseIndexName {
    private final String catalogName;
    private final String schemaName;
    private final String indexName;

    public DatabaseIndexName(String schemaName, String indexName) {
        this(null, schemaName, indexName);
    }

    public DatabaseIndexName(String indexName) {
        this(null, null, indexName);
    }

    public DatabaseIndexName(String catalogName, String schemaName, String indexName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.indexName = indexName;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public int hashCode() {
        int result = 31 + (this.catalogName == null ? 0 : this.catalogName.hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        return 31 * result + (this.indexName == null ? 0 : this.indexName.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IDatabaseTriggerName)) {
            return false;
        }
        IDatabaseTriggerName other = (IDatabaseTriggerName)obj;
        return ObjectUtilities.equals((Object)this.catalogName, (Object)other.getCatalogName()) && ObjectUtilities.equals((Object)this.schemaName, (Object)other.getSchemaName()) && ObjectUtilities.equals((Object)this.indexName, (Object)other.getTriggerName());
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder();
        if (!StringUtilities.isNullOrEmpty((String)this.catalogName)) {
            builder.append(this.catalogName);
            builder.append(".");
        }
        if (!StringUtilities.isNullOrEmpty((String)this.schemaName)) {
            builder.append(this.schemaName);
            builder.append(".");
        }
        builder.append(this.indexName);
        return builder.toString();
    }
}

