/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.anwiba.commons.jdbc.BatchTransfer;
import net.anwiba.commons.jdbc.IBatchTransfer;
import net.anwiba.commons.jdbc.connection.IDatabaseConnector;
import net.anwiba.commons.jdbc.connection.IJdbcConnectionDescription;
import net.anwiba.commons.jdbc.constraint.Constraint;
import net.anwiba.commons.jdbc.constraint.ConstraintType;
import net.anwiba.commons.jdbc.result.IResult;
import net.anwiba.commons.jdbc.result.IResults;
import net.anwiba.commons.jdbc.result.ResultSetToResultAdapter;
import net.anwiba.commons.jdbc.result.ResultSetToResultsAdapter;
import net.anwiba.commons.jdbc.value.IDatabaseValue;
import net.anwiba.commons.lang.counter.Counter;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.functional.IClosableIterator;
import net.anwiba.commons.lang.functional.ICloseable;
import net.anwiba.commons.lang.functional.ICloseableConsumer;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.functional.IFunction;
import net.anwiba.commons.lang.functional.IInterruptableFunction;
import net.anwiba.commons.lang.functional.IInterruptableProcedure;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.lang.functional.IWatcher;
import net.anwiba.commons.lang.number.ComparableNumber;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.primitive.BooleanContainer;
import net.anwiba.commons.lang.primitive.IBooleanContainer;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class DatabaseUtilities {
    private static ILogger logger = Logging.getLogger((String)DatabaseUtilities.class.getName());

    public static Driver loadDriver(String driverName) {
        try {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                if (!driver.getClass().getName().equals(driverName)) continue;
                return driver;
            }
            Class<?> driverClass = Class.forName(driverName);
            if (driverClass != null) {
                Driver driver = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DriverManager.registerDriver(driver);
                return driver;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SQLException sQLException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static Connection createConnection(String url, String user, String password, boolean isReadOnly) throws SQLException {
        Connection connection = DriverManager.getConnection(url, user, password);
        connection.setReadOnly(isReadOnly);
        return connection;
    }

    public static Connection createConnection(String url, String user, String password) throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    public static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static <O> SQLException close(IClosableIterator<O, SQLException> iteratror, SQLException exception) {
        if (iteratror == null) {
            return exception;
        }
        try {
            iteratror.close();
            return exception;
        }
        catch (SQLException sqlException) {
            if (exception == null) {
                return sqlException;
            }
            exception.addSuppressed(sqlException);
            return exception;
        }
    }

    public static SQLException close(Connection connection, SQLException exception) {
        if (connection == null) {
            return exception;
        }
        try {
            connection.close();
            return exception;
        }
        catch (SQLException sqlException) {
            if (exception == null) {
                return sqlException;
            }
            exception.addSuppressed(sqlException);
            return exception;
        }
    }

    public static SQLException close(Statement statement, SQLException exception) {
        if (statement == null) {
            return exception;
        }
        try {
            statement.close();
            return exception;
        }
        catch (SQLException sqlException) {
            if (exception == null) {
                return sqlException;
            }
            exception.addSuppressed(sqlException);
            return exception;
        }
    }

    public static SQLException close(ResultSet resultSet, SQLException exception) {
        if (resultSet == null) {
            return exception;
        }
        try {
            resultSet.close();
            return exception;
        }
        catch (SQLException sqlException) {
            if (exception == null) {
                return sqlException;
            }
            exception.addSuppressed(sqlException);
            return exception;
        }
    }

    public static SQLException close(IResults results, SQLException exception) {
        if (results == null) {
            return exception;
        }
        try {
            results.close();
            return exception;
        }
        catch (SQLException sqlException) {
            if (exception == null) {
                return sqlException;
            }
            exception.addSuppressed(sqlException);
            return exception;
        }
    }

    public static void close(IResults results) {
        try {
            if (results != null) {
                results.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getStatementString(Connection connection, double beforVersion, String statement, String defaultStatement) throws SQLException {
        double version = DatabaseUtilities.getVersionAsDouble(connection);
        if (version < beforVersion) {
            return statement;
        }
        return defaultStatement;
    }

    public static double getVersionAsDouble(Connection connection) throws SQLException {
        int mayor = DatabaseUtilities.getMajorVersion(connection);
        int minor = DatabaseUtilities.getMinorVersion(connection);
        double version = (double)mayor + Double.parseDouble("0." + String.valueOf(minor));
        return version;
    }

    public static String getProduct(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseProductName();
    }

    public static String getVersion(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseProductVersion();
    }

    public static int getMajorVersion(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseMajorVersion();
    }

    public static int getMinorVersion(Connection connection) throws SQLException {
        return connection.getMetaData().getDatabaseMinorVersion();
    }

    public static String getCompleteSqlExceptionMessageText(SQLException exception) {
        return DatabaseUtilities.getCompleteSqlExceptionMessageText(exception, new HashSet<Throwable>());
    }

    private static String getCompleteSqlExceptionMessageText(Throwable exception, Set<Throwable> visited) {
        Object message;
        if (exception == null || visited.contains(exception)) {
            return "";
        }
        visited.add(exception);
        Object object = message = exception instanceof SQLException ? exception.getMessage() : "";
        if (exception instanceof SQLException) {
            SQLException sqlException = (SQLException)exception;
            return (String)message + (((String)message).isBlank() ? "" : "\n") + DatabaseUtilities.getCompleteSqlExceptionMessageText(sqlException.getNextException(), visited);
        }
        if (exception.getCause() != null) {
            Throwable cause = exception.getCause();
            message = (String)message + (((String)message).isBlank() ? "" : "\n") + DatabaseUtilities.getCompleteSqlExceptionMessageText(cause, visited);
        }
        for (Throwable throwable : exception.getSuppressed()) {
            message = (String)message + (((String)message).isBlank() ? "" : "\n") + DatabaseUtilities.getCompleteSqlExceptionMessageText(throwable, visited);
        }
        return message;
    }

    public static Map<String, Constraint> readConstraints(Connection connection, String selectStatement, String schemaName, String tableName) throws SQLException {
        HashMap<String, Constraint> hashMap;
        block17: {
            logger.log(ILevel.DEBUG, "Query: Schema " + schemaName + " table " + tableName);
            logger.log(ILevel.DEBUG, "Query: " + selectStatement);
            PreparedStatement statement = connection.prepareStatement(selectStatement);
            try {
                HashMap<String, Constraint> constraints = new HashMap<String, Constraint>();
                statement.setString(1, schemaName);
                statement.setString(2, tableName);
                if (statement.execute()) {
                    try (ResultSet resultSet = statement.getResultSet();){
                        while (resultSet.next()) {
                            String columnName = resultSet.getString(1);
                            String constraintName = resultSet.getString(2);
                            ConstraintType constraintType = ConstraintType.getTypeById(resultSet.getString(3));
                            String condition = resultSet.getString(4);
                            Constraint constraint = DatabaseUtilities.getConstraint(constraints, constraintName, constraintType, condition);
                            constraint.add(columnName);
                        }
                    }
                }
                hashMap = constraints;
                if (statement == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    throw new SQLException("Executing statement '" + selectStatement + "' faild", exception);
                }
            }
            statement.close();
        }
        return hashMap;
    }

    public static Constraint getConstraint(Map<String, Constraint> constraints, String constraintName, ConstraintType constraintType, String condition) {
        Constraint constraint = constraints.get(constraintName);
        if (constraint == null) {
            constraint = new Constraint(constraintName, constraintType, condition);
            constraints.put(constraintName, constraint);
        }
        return constraint;
    }

    public static void dropTable(Connection connection, String schemaName, String tableName) throws SQLException {
        String qualifiedTableName = schemaName == null ? tableName : schemaName + "." + tableName;
        String statementString = "DROP TABLE " + qualifiedTableName;
        DatabaseUtilities.execute(connection, statementString);
    }

    public static void dropIndex(Connection connection, String schemaName, String indexName) throws SQLException {
        String qualifiedIndexName = schemaName == null ? indexName : schemaName + "." + indexName;
        String statementString = "DROP INDEX " + qualifiedIndexName;
        DatabaseUtilities.execute(connection, statementString);
    }

    public static String getOwner(Connection connection, String owner) throws SQLException {
        return owner == null ? connection.getMetaData().getUserName() : owner;
    }

    public static <T> List<T> results(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IConverter<IResult, T, SQLException> function) throws SQLException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            List<T> list = DatabaseUtilities.results(connection, statementString, function);
            return list;
        }
    }

    public static <T> List<T> results(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IResult, T, SQLException> function) throws SQLException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            List<T> list = DatabaseUtilities.results(connection, statementString, prepareProcedure, function);
            return list;
        }
    }

    public static <T> List<T> results(Connection connection, String statementString, IConverter<IResult, T, SQLException> function) throws SQLException {
        return DatabaseUtilities.results(connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)statement -> {}), function);
    }

    public static <T> List<T> results(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IResult, T, SQLException> resultProcedure) throws SQLException {
        ArrayList<Object> arrayList;
        block17: {
            logger.log(ILevel.DEBUG, "Statement: " + statementString);
            PreparedStatement statement = connection.prepareStatement(statementString);
            try {
                prepareProcedure.execute((Object)statement);
                ArrayList<Object> resultList = new ArrayList<Object>();
                if (statement.execute()) {
                    try (ResultSet resultSet = statement.getResultSet();){
                        ResultSetToResultAdapter result = new ResultSetToResultAdapter(resultSet);
                        while (resultSet.next()) {
                            Object object = resultProcedure.convert((Object)result);
                            if (object == null) continue;
                            resultList.add(object);
                        }
                    }
                }
                arrayList = resultList;
                if (statement == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    throw new SQLException("Executing statement '" + statementString + "' faild", exception);
                }
            }
            statement.close();
        }
        return arrayList;
    }

    public static <T> List<T> results(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, Connection connection, String statementString, IConverter<IResult, T, SQLException> resultFunction) throws SQLException {
        return DatabaseUtilities.results(cancelWatcherFactory, connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)s -> {}), resultFunction);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> results(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IResult, T, SQLException> resultConverter) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        BooleanContainer flag = new BooleanContainer(true);
        try (PreparedStatement statement = connection.prepareStatement(statementString);){
            ArrayList<Object> arrayList;
            block23: {
                ICloseable cancler = (ICloseable)cancelWatcherFactory.create(() -> DatabaseUtilities.lambda$results$2((IBooleanContainer)flag, statement));
                try {
                    prepareProcedure.execute((Object)statement);
                    ArrayList<Object> resultList = new ArrayList<Object>();
                    if (flag.isTrue() && statement.execute()) {
                        try (ResultSet resultSet = statement.getResultSet();){
                            ResultSetToResultAdapter result = new ResultSetToResultAdapter(resultSet);
                            while (flag.isTrue() && resultSet.next()) {
                                Object object = resultConverter.convert((Object)result);
                                if (object == null) continue;
                                resultList.add(object);
                            }
                        }
                    }
                    arrayList = resultList;
                    if (cancler == null) break block23;
                }
                catch (Throwable throwable) {
                    if (cancler != null) {
                        try {
                            cancler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cancler.close();
            }
            return arrayList;
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static void foreach(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConsumer<IResult, SQLException> resultConsumer) throws SQLException {
        block21: {
            logger.log(ILevel.DEBUG, "Statement: " + statementString);
            BooleanContainer flag = new BooleanContainer(true);
            try (PreparedStatement statement = connection.prepareStatement(statementString);
                 ICloseable cancler = (ICloseable)cancelWatcherFactory.create(() -> DatabaseUtilities.lambda$foreach$3((IBooleanContainer)flag, statement));){
                prepareProcedure.execute((Object)statement);
                if (!flag.isTrue() || !statement.execute()) break block21;
                try (ResultSet resultSet = statement.getResultSet();){
                    ResultSetToResultAdapter result = new ResultSetToResultAdapter(resultSet);
                    while (flag.isTrue() && resultSet.next()) {
                        resultConsumer.consume((Object)result);
                    }
                }
            }
            catch (SQLException exception) {
                throw new SQLException("Executing statement '" + statementString + "' faild", exception);
            }
        }
    }

    public static ResultSet resultSet(Connection connection, String string) throws SQLException {
        return DatabaseUtilities.resultSet(connection, string, (IProcedure<PreparedStatement, SQLException>)((IProcedure)value -> {}));
    }

    public static <T> ResultSet resultSet(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        try {
            logger.log(ILevel.DEBUG, "Statement: " + statementString);
            PreparedStatement statement = connection.prepareStatement(statementString);
            prepareProcedure.execute((Object)statement);
            if (statement.execute()) {
                return statement.getResultSet();
            }
            return null;
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static String stringResult(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            String string = DatabaseUtilities.stringResult(connection, statementString, prepareProcedure);
            return string;
        }
    }

    public static String stringResult(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.stringResult(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    public static String stringResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        IFunction<IResult, String, SQLException> resultFunction = new IFunction<IResult, String, SQLException>(){

            public String execute(IResult value) throws SQLException {
                if (value == null) {
                    return null;
                }
                return value.getString(1);
            }
        };
        return DatabaseUtilities.stringResult(connection, statementString, prepareProcedure, resultFunction);
    }

    public static String stringResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IOptional<IResult, SQLException>, String, SQLException> resultFunction) throws SQLException {
        return DatabaseUtilities.result(connection, statementString, prepareProcedure, resultFunction);
    }

    public static Long longResult(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            Long l = DatabaseUtilities.longResult(connection, statementString, prepareProcedure);
            return l;
        }
    }

    public static Long longResult(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.longResult(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    public static Long longResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        IConverter<IResult, Long, SQLException> resultFunction = new IConverter<IResult, Long, SQLException>(){

            public Long convert(IResult value) throws SQLException {
                if (value == null) {
                    return null;
                }
                return value.getLong(1);
            }
        };
        return DatabaseUtilities.longResult(connection, statementString, new Object[]{prepareProcedure, resultFunction});
    }

    public static Long longResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IOptional<IResult, SQLException>, Long, SQLException> resultFunction) throws SQLException {
        return DatabaseUtilities.result(connection, statementString, prepareProcedure, resultFunction);
    }

    public static boolean booleanResult(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            boolean bl = DatabaseUtilities.booleanResult(connection, statementString, prepareProcedure);
            return bl;
        }
    }

    public static boolean booleanResult(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.booleanResult(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    public static boolean booleanResult(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        return DatabaseUtilities.result(connection, statementString, prepareProcedure, new IConverter<IOptional<IResult, SQLException>, Boolean, SQLException>(){

            public Boolean convert(IOptional<IResult, SQLException> value) throws SQLException {
                return (Boolean)value.convert(v -> v.getBoolean(1, false)).getOr(() -> Boolean.FALSE);
            }
        });
    }

    public static <T> T result(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IOptional<IResult, SQLException>, T, SQLException> resultFunction) throws SQLException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            T t = DatabaseUtilities.result(connection, statementString, prepareProcedure, resultFunction);
            return t;
        }
    }

    public static <T> T result(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IConverter<IOptional<IResult, SQLException>, T, SQLException> resultFunction) throws SQLException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            T t = DatabaseUtilities.result(connection, statementString, resultFunction);
            return t;
        }
    }

    public static <T> T result(Connection connection, String statementString, IConverter<IOptional<IResult, SQLException>, T, SQLException> function) throws SQLException {
        return DatabaseUtilities.result(connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)statement -> {}), function);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T result(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IOptional<IResult, SQLException>, T, SQLException> resultFunction) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try (PreparedStatement statement = connection.prepareStatement(statementString);){
            prepareProcedure.execute((Object)statement);
            if (statement.execute()) {
                try (ResultSet resultSet = statement.getResultSet();){
                    ResultSetToResultAdapter result = new ResultSetToResultAdapter(resultSet);
                    if (resultSet.next()) {
                        Object value = resultFunction.convert((Object)Optional.of(SQLException.class, (Object)result));
                        if (resultSet.next()) {
                            throw new SQLException("Statement result isn't unique '" + statementString + "'");
                        }
                        Object object = value;
                        return (T)object;
                    }
                }
            }
            Object object = resultFunction.convert((Object)Optional.empty(SQLException.class));
            return (T)object;
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static <T> T result(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<IOptional<IResult, SQLException>, T, SQLException> resultFunction) throws SQLException {
        DatabaseUtilities.logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try {
            statement = connection.prepareStatement(statementString);
            try {
                block26: {
                    block23: {
                        block25: {
                            block24: {
                                cancler = (ICloseable)cancelWatcherFactory.create((Object)(IBlock)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$result$6(java.sql.PreparedStatement ), ()V)((PreparedStatement)statement));
                                prepareProcedure.execute((Object)statement);
                                if (!statement.execute()) ** GOTO lbl37
                                resultSet = statement.getResultSet();
                                result = new ResultSetToResultAdapter(resultSet);
                                if (!resultSet.next()) break block23;
                                value = resultFunction.convert((Object)Optional.of(SQLException.class, (Object)result));
                                if (resultSet.next()) {
                                    throw new SQLException("Statement result isn't unique '" + statementString + "'");
                                }
                                var10_17 = value;
                                if (resultSet == null) break block24;
                                resultSet.close();
                            }
                            if (cancler == null) break block25;
                            cancler.close();
                        }
                        return (T)var10_17;
                    }
                    try {
                        block27: {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            break block27;
                            {
                                catch (Throwable var8_13) {
                                    if (resultSet != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable var9_16) {
                                            var8_13.addSuppressed(var9_16);
                                        }
                                    }
                                    throw var8_13;
                                }
                            }
                        }
                        var7_9 = resultFunction.convert((Object)Optional.empty(SQLException.class));
                        if (cancler == null) break block26;
                    }
                    catch (Throwable var7_10) {
                        if (cancler != null) {
                            try {
                                cancler.close();
                            }
                            catch (Throwable var8_14) {
                                var7_10.addSuppressed(var8_14);
                            }
                        }
                        throw var7_10;
                    }
                    cancler.close();
                }
                return (T)var7_9;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static <T> List<T> results(Connection connection, String statementString, IInterruptableFunction<IResult, T, SQLException> resultFunction) throws SQLException, CanceledException {
        return DatabaseUtilities.results((IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException>)((IFactory)b -> () -> {}), connection, statementString, (IInterruptableProcedure<PreparedStatement, SQLException>)((IInterruptableProcedure)s -> {}), resultFunction);
    }

    public static <T> List<T> results(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IInterruptableFunction<IResult, T, SQLException> resultFunction) throws SQLException, CanceledException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            List<T> list = DatabaseUtilities.results((IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException>)((IFactory)b -> () -> {}), connection, statementString, (IInterruptableProcedure<PreparedStatement, SQLException>)((IInterruptableProcedure)s -> {}), resultFunction);
            return list;
        }
    }

    public static <T> List<T> results(Connection connection, String statementString, IInterruptableProcedure<PreparedStatement, SQLException> prepareClosure, IInterruptableFunction<IResult, T, SQLException> resultFunction) throws SQLException, CanceledException {
        return DatabaseUtilities.results((IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException>)((IFactory)b -> () -> {}), connection, statementString, prepareClosure, resultFunction);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> results(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, Connection connection, String statementString, IInterruptableProcedure<PreparedStatement, SQLException> prepareClosure, IInterruptableFunction<IResult, T, SQLException> resultProcedure) throws SQLException, CanceledException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        BooleanContainer flag = new BooleanContainer(true);
        try (PreparedStatement statement = connection.prepareStatement(statementString);){
            ArrayList<Object> arrayList;
            block23: {
                ICloseable cancler = (ICloseable)cancelWatcherFactory.create(() -> DatabaseUtilities.lambda$results$15((IBooleanContainer)flag, statement));
                try {
                    prepareClosure.execute((Object)statement);
                    ArrayList<Object> resultList = new ArrayList<Object>();
                    if (flag.isTrue() && statement.execute()) {
                        try (ResultSet resultSet = statement.getResultSet();){
                            ResultSetToResultAdapter result = new ResultSetToResultAdapter(resultSet);
                            while (flag.isTrue() && resultSet.next()) {
                                Object object = resultProcedure.execute((Object)result);
                                if (object == null) continue;
                                resultList.add(object);
                            }
                        }
                    }
                    arrayList = resultList;
                    if (cancler == null) break block23;
                }
                catch (Throwable throwable) {
                    if (cancler != null) {
                        try {
                            cancler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cancler.close();
            }
            return arrayList;
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static <T> T aggregate(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, IConverter<Iterable<IResult>, T, SQLException> function) throws SQLException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            T t = DatabaseUtilities.aggregate(connection, statementString, function);
            return t;
        }
    }

    public static <T> T aggregate(Connection connection, String statementString, IConverter<Iterable<IResult>, T, SQLException> function) throws SQLException {
        return DatabaseUtilities.aggregate(connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)statement -> {}), function);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static <T> T aggregate(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IConverter<Iterable<IResult>, T, SQLException> resultProcedure) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try {
            PreparedStatement statement = connection.prepareStatement(statementString);
            prepareProcedure.execute((Object)statement);
            if (statement.execute()) {
                final ResultSet resultSet = statement.getResultSet();
                final ArrayList exceptions = new ArrayList(4);
                final ResultSetToResultAdapter result = new ResultSetToResultAdapter(resultSet);
                Iterable iterable = () -> new Iterator<IResult>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return resultSet.next();
                        }
                        catch (SQLException exception) {
                            exceptions.add(exception);
                            return false;
                        }
                    }

                    @Override
                    public IResult next() {
                        return result;
                    }
                };
                Object object = resultProcedure.convert(iterable);
                return (T)object;
                {
                    catch (SQLException exception) {
                        for (SQLException sqlException : exceptions) {
                            sqlException.addSuppressed(exception);
                            exception = sqlException;
                        }
                        throw exception;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            Object object = resultProcedure.convert(new ArrayList());
            return (T)object;
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IProcedure<ResultSet, SQLException> resultProcedure) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try (PreparedStatement statement = connection.prepareStatement(statementString);){
            prepareProcedure.execute((Object)statement);
            if (statement.execute()) {
                try (ResultSet resultSet = statement.getResultSet();){
                    resultProcedure.execute((Object)resultSet);
                    boolean bl = true;
                    return bl;
                }
            }
            return statement.getUpdateCount() > 0;
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static final boolean execute(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.execute(connection, statementString, DatabaseUtilities.setterProcedur(values), (IProcedure<ResultSet, SQLException>)((IProcedure)each -> {}));
    }

    public static final boolean call(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.call(connection, statementString, DatabaseUtilities.setterProcedur(values), (IProcedure<ResultSet, SQLException>)((IProcedure)each -> {}));
    }

    public static final boolean call(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> procedure) throws SQLException {
        return DatabaseUtilities.call(connection, statementString, procedure, (IProcedure<ResultSet, SQLException>)((IProcedure)each -> {}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean call(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure, IProcedure<ResultSet, SQLException> resultProcedure) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try (CallableStatement statement = connection.prepareCall(statementString);){
            prepareProcedure.execute((Object)statement);
            if (statement.execute()) {
                try (ResultSet resultSet = statement.getResultSet();){
                    resultProcedure.execute((Object)resultSet);
                    boolean bl = true;
                    return bl;
                }
            }
            return statement.getUpdateCount() > 0;
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static IProcedure<PreparedStatement, SQLException> setterProcedur(List objects) {
        return statement -> {
            for (int i = 0; i < objects.size(); ++i) {
                logger.log(ILevel.DEBUG, "  value: " + DatabaseUtilities.toDebugString(objects.get(i)));
                Object adjustValue = DatabaseUtilities.adjustValue(objects.get(i));
                if (adjustValue == null) {
                    statement.setNull(i + 1, 0);
                    continue;
                }
                statement.setObject(i + 1, adjustValue);
            }
        };
    }

    public static IProcedure<PreparedStatement, SQLException> setterProcedur(Object ... objects) {
        return statement -> {
            for (int i = 0; i < objects.length; ++i) {
                logger.log(ILevel.DEBUG, "  value: " + DatabaseUtilities.toDebugString(objects[i]));
                Object adjustValue = DatabaseUtilities.adjustValue(objects[i]);
                if (adjustValue == null) {
                    statement.setNull(i + 1, 0);
                    continue;
                }
                statement.setObject(i + 1, adjustValue);
            }
        };
    }

    public static Object adjustValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date && !(value instanceof Date) && !(value instanceof Timestamp) && !(value instanceof Time)) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof ComparableNumber) {
            return DatabaseUtilities.adjustValue(value);
        }
        if (value instanceof Double) {
            if (Double.isNaN((Double)value)) {
                return null;
            }
            return value;
        }
        return value;
    }

    public static int count(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String statementString, Object ... values) throws SQLException {
        try (Connection connection = connector.connectReadOnly(connectionDescription);){
            int n = DatabaseUtilities.count(connection, statementString, values);
            return n;
        }
    }

    public static int count(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.count(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long next(Connection connection, String nextValueStatement) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + nextValueStatement);
        try (PreparedStatement statement = connection.prepareStatement(nextValueStatement);){
            if (statement.execute()) {
                try (ResultSet resultSet = statement.getResultSet();){
                    if (resultSet.next()) {
                        Number number = (Number)resultSet.getObject(1);
                        if (number == null) {
                            Long l = null;
                            return l;
                        }
                        Long l = number.longValue();
                        return l;
                    }
                }
            }
            Long l = null;
            return l;
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + nextValueStatement + "' faild", exception);
        }
    }

    public static int count(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        int n;
        block8: {
            logger.log(ILevel.DEBUG, "Statement: " + statementString);
            PreparedStatement statement = connection.prepareStatement(statementString);
            try {
                n = DatabaseUtilities.count(statement, prepareProcedure);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    throw new SQLException("Executing statement '" + statementString + "' faild", exception);
                }
            }
            statement.close();
        }
        return n;
    }

    public static int count(PreparedStatement statement, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        prepareProcedure.execute((Object)statement);
        if (statement.execute()) {
            try (ResultSet resultSet = statement.getResultSet();){
                if (resultSet.next()) {
                    Object object = resultSet.getObject(1);
                    if (!(object instanceof Number)) {
                        int n = 0;
                        return n;
                    }
                    Number number = (Number)object;
                    int n = number.intValue();
                    return n;
                }
            }
        }
        return 0;
    }

    public static boolean contains(Connection connection, String statementString, String columnName, Object value) throws SQLException {
        Boolean count = (Boolean)DatabaseUtilities.aggregate(connection, statementString, results -> {
            for (IResult result : results) {
                Object object = result.getObject(columnName);
                if (!ObjectUtilities.equals((Object)value, (Object)object)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
        return count;
    }

    public static boolean execute(Connection connection, String statementString) throws SQLException {
        return DatabaseUtilities.execute(connection, statementString, (IProcedure<PreparedStatement, SQLException>)((IProcedure)statement -> {}));
    }

    public static final boolean execute(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> procedure) throws SQLException {
        return DatabaseUtilities.execute(connection, statementString, procedure, (IProcedure<ResultSet, SQLException>)((IProcedure)each -> {}));
    }

    public static void execute(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, IProcedure<Connection, SQLException> procedure) throws SQLException {
        try (Connection connection = connector.connectWritable(connectionDescription, true);){
            procedure.execute((Object)connection);
        }
    }

    public static boolean exists(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription) {
        boolean bl;
        block8: {
            Connection connection = connector.connectReadOnly(connectionDescription);
            try {
                bl = true;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    logger.log(ILevel.WARNING, exception.getMessage(), (Throwable)exception);
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public static List<Object> update(Connection connection, String statementString, String[] returnColumns, Object ... values) throws SQLException {
        return DatabaseUtilities.update(connection, statementString, returnColumns, DatabaseUtilities.setterProcedur(values));
    }

    public static List<Object> update(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String updatetStatement, String[] returnColumns, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        try (Connection connection = connector.connectWritable(connectionDescription, true);){
            List<Object> list = DatabaseUtilities.update(connection, updatetStatement, returnColumns, prepareProcedure);
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Object> update(Connection connection, String statementString, String[] returnColumns, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try (PreparedStatement statement = connection.prepareStatement(statementString, returnColumns);){
            prepareProcedure.execute((Object)statement);
            int numberOfChangedRows = statement.executeUpdate();
            if (numberOfChangedRows == 0) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                return arrayList2;
            }
            ArrayList<Object> keys = new ArrayList<Object>();
            try (ResultSet generatedKeys = statement.getGeneratedKeys();){
                while (generatedKeys.next()) {
                    Object key = generatedKeys.getObject(1);
                    logger.log(ILevel.DEBUG, "    key: " + DatabaseUtilities.toDebugString(key));
                    keys.add(key);
                }
            }
            ArrayList<Object> arrayList = keys;
            return arrayList;
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static List<Object> update(Connection connection, String statementString, Object ... values) throws SQLException {
        return DatabaseUtilities.update(connection, statementString, DatabaseUtilities.setterProcedur(values));
    }

    public static List<Object> update(IDatabaseConnector connector, IJdbcConnectionDescription connectionDescription, String updatetStatement, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        try (Connection connection = connector.connectWritable(connectionDescription, true);){
            List<Object> list = DatabaseUtilities.update(connection, updatetStatement, prepareProcedure);
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Object> update(Connection connection, String statementString, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        logger.log(ILevel.DEBUG, "Statement: " + statementString);
        try {
            PreparedStatement statement = connection.prepareStatement(statementString, 1);
            try {
                prepareProcedure.execute((Object)statement);
                int numberOfChangedRows = statement.executeUpdate();
                if (numberOfChangedRows == 0) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    return arrayList;
                }
                ArrayList<Object> keys = new ArrayList<Object>();
                try (ResultSet generatedKeys = statement.getGeneratedKeys();){
                    while (generatedKeys.next()) {
                        Object key = generatedKeys.getObject(1);
                        logger.log(ILevel.DEBUG, "    key: " + DatabaseUtilities.toDebugString(key));
                        keys.add(key);
                    }
                }
                ArrayList<Object> arrayList = keys;
                return arrayList;
            }
            catch (SQLException exception) {
                throw exception;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    public static <I> ICloseableConsumer<I, Boolean, SQLException> update(IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, final Connection connection, String statementString, final IConverter<I, List<IDatabaseValue>, SQLException> converter) {
        IAggregator aggregator = new IAggregator<PreparedStatement, I, Boolean, SQLException>(){

            public Boolean aggregate(PreparedStatement statement, I object) throws SQLException {
                List values = (List)converter.convert(object);
                if (values.isEmpty()) {
                    return false;
                }
                for (int i = 0; i < values.size(); ++i) {
                    this.setTo(statement, i + 1, (IDatabaseValue)values.get(i));
                }
                return true;
            }

            private void setTo(PreparedStatement statement, int i, IDatabaseValue value) throws SQLException {
                try {
                    if (value.getObject(connection) == null) {
                        if (value.getTypeName() != null) {
                            statement.setNull(i, value.getType(), value.getTypeName());
                        } else {
                            statement.setNull(i, value.getType());
                        }
                        return;
                    }
                    statement.setObject(i, value.getObject(connection));
                }
                catch (SQLException exception) {
                    logger.log(ILevel.WARNING, "Couldn't set value on column '" + i + "'", (Throwable)exception);
                    if (value.getTypeName() != null) {
                        statement.setNull(i, value.getType(), value.getTypeName());
                    }
                    statement.setNull(i, value.getType());
                }
            }
        };
        return DatabaseUtilities.update(cancelWatcherFactory, connection, statementString, aggregator);
    }

    public static <I> ICloseableConsumer<I, Boolean, SQLException> update(final IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, final Connection connection, final String statementString, final IAggregator<PreparedStatement, I, Boolean, SQLException> aggregator) {
        return new ICloseableConsumer<I, Boolean, SQLException>(){
            private IWatcher statementCancler;
            private boolean isClosed = false;
            private PreparedStatement statement;

            public void close() throws SQLException {
                if (this.isClosed) {
                    throw new SQLException("consumer is closed");
                }
                this.isClosed = true;
                this.statementCancler.close();
                SQLException exception = DatabaseUtilities.close(this.statement, null);
                if (exception != null) {
                    throw exception;
                }
            }

            public Boolean consume(I object) throws SQLException {
                Boolean aggregated;
                if (this.isClosed) {
                    throw new SQLException("consumer is closed");
                }
                if (this.statement == null) {
                    this.initialize();
                }
                if ((aggregated = (Boolean)aggregator.aggregate((Object)this.statement, object)).booleanValue()) {
                    this.statement.addBatch();
                }
                return aggregated;
            }

            private void initialize() throws SQLException {
                logger.log(ILevel.DEBUG, statementString);
                this.statement = connection.prepareStatement(statementString);
                this.statementCancler = (IWatcher)cancelWatcherFactory.create(() -> {
                    try {
                        this.statement.cancel();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                });
            }
        };
    }

    public static void add(PreparedStatement statement, Object ... values) throws SQLException {
        DatabaseUtilities.add(statement, DatabaseUtilities.setterProcedur(values));
    }

    public static void add(PreparedStatement statement, IProcedure<PreparedStatement, SQLException> prepareProcedure) throws SQLException {
        prepareProcedure.execute((Object)statement);
        statement.addBatch();
    }

    public static int[] transfer(PreparedStatement statement) throws SQLException {
        return statement.executeBatch();
    }

    public IDatabaseValue value(Object object, int type) {
        return this.value(object, type, null);
    }

    public IDatabaseValue value(final Object object, final int type, final String typeName) {
        return new IDatabaseValue(){

            @Override
            public String getTypeName() {
                return typeName;
            }

            @Override
            public int getType() {
                return type;
            }

            @Override
            public Object getObject(Connection connection) throws SQLException {
                return object;
            }
        };
    }

    public static <T> IClosableIterator<T, SQLException> query(final IFactory<IBlock<RuntimeException>, IWatcher, RuntimeException> cancelWatcherFactory, final Connection connection, final String statementString, final IProcedure<PreparedStatement, SQLException> prepareProcedure, final IConverter<IResult, T, SQLException> converter) {
        return new IClosableIterator<T, SQLException>(){
            private boolean isClosed = false;
            private IResults results;
            private T value;
            private IWatcher statementCancler;
            private PreparedStatement statement;

            public void close() throws SQLException {
                if (this.isClosed) {
                    throw new SQLException("iterator is closed");
                }
                this.statementCancler.close();
                SQLException exception = DatabaseUtilities.close(this.results, null);
                exception = DatabaseUtilities.close(this.statement, exception);
                this.isClosed = true;
                if (exception != null) {
                    throw exception;
                }
            }

            public boolean hasNext() throws SQLException {
                if (this.isClosed) {
                    throw new SQLException("iterator is closed");
                }
                if (this.value != null) {
                    return true;
                }
                if (this.results == null && (this.results = this.initialize()) == null) {
                    return false;
                }
                while (this.results.hasNext()) {
                    IResult result = (IResult)this.results.next();
                    this.value = converter.convert((Object)result);
                    if (this.value == null) continue;
                    return true;
                }
                return false;
            }

            private IResults initialize() throws SQLException {
                logger.log(ILevel.DEBUG, statementString);
                this.statement = connection.prepareStatement(statementString);
                this.statementCancler = (IWatcher)cancelWatcherFactory.create(() -> {
                    try {
                        this.statement.cancel();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                });
                prepareProcedure.execute((Object)this.statement);
                if (this.statement.execute()) {
                    return new ResultSetToResultsAdapter(this.statement.getResultSet());
                }
                return null;
            }

            public T next() throws SQLException {
                if (this.isClosed) {
                    throw new SQLException("iterator is closed");
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Object t = this.value;
                    return t;
                }
                finally {
                    this.value = null;
                }
            }
        };
    }

    private static String toDebugString(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return object.getClass().getSimpleName();
        }
        return String.valueOf(object);
    }

    public static String getSchemaName(Connection connection, String schemaName) throws SQLException {
        return schemaName == null ? connection.getMetaData().getUserName() : schemaName;
    }

    public static void createIfNotExists(Connection connection, String schemaName, String tableName, String createStatementString) throws SQLException {
        if (DatabaseUtilities.exists(connection, schemaName, tableName)) {
            return;
        }
        DatabaseUtilities.create(connection, createStatementString);
    }

    public static boolean exists(Connection connection, String schemaName, String tableName) throws SQLException {
        try (ResultSet tables = connection.getMetaData().getTables(connection.getCatalog(), schemaName, tableName, new String[]{"TABLE", "VIEW", "SYSTEM TABLE", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "ALIAS", "SYNONYM"});){
            boolean bl = tables.next();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(Statement statement, String statementString) throws SQLException {
        try {
            logger.log(ILevel.DEBUG, "Statement: " + statementString);
            if (!statement.execute(statementString)) {
                return false;
            }
            try (ResultSet resultSet = statement.getResultSet();){
                if (!resultSet.next()) {
                    boolean bl = false;
                    return bl;
                }
                if (resultSet.getInt(1) == 0) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException exception) {
            throw new SQLException("Executing statement '" + statementString + "' faild", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAsString(Statement statement, String statementString) {
        try {
            if (!statement.execute(statementString)) return null;
            try (ResultSet resultSet = statement.getResultSet();){
                if (!resultSet.next()) return null;
                String string = String.valueOf(resultSet.getObject(1));
                return string;
            }
        }
        catch (SQLException exception) {
            logger.log(ILevel.WARNING, exception.getMessage());
        }
        return null;
    }

    public static String createSelectStatement(String tableName, Iterable<String> columnNames, Iterable<String> valueColumnNames) {
        return DatabaseUtilities.createSelectStatement(tableName, columnNames, null, valueColumnNames);
    }

    public static String createSelectStatement(String tableName, Iterable<String> conditionColumnNames, String orderByColumnName, Iterable<String> resultColumnNames) {
        boolean flag = false;
        StringBuilder builder = new StringBuilder();
        for (String columnName : resultColumnNames) {
            if (!flag) {
                builder.append("select ");
                builder.append(columnName);
                builder.append("\n");
                flag = true;
                continue;
            }
            builder.append("     , ");
            builder.append(columnName);
            builder.append("\n");
        }
        builder.append("  from ");
        builder.append(tableName);
        builder.append("\n");
        boolean clauseFlag = false;
        for (String columnName : conditionColumnNames) {
            if (!clauseFlag) {
                builder.append(" where ");
                clauseFlag = true;
            } else {
                builder.append(" and ");
            }
            builder.append(columnName);
            builder.append(" = ?");
        }
        builder.append("\n");
        if (!StringUtilities.isNullOrEmpty((String)orderByColumnName)) {
            builder.append(" order by ");
            builder.append(orderByColumnName);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String createIdentifierSelectStatement(String tableName, String identifierColumnName, Iterable<String> valueColumnNames) {
        return DatabaseUtilities.createIdentifierSelectStatement(tableName, identifierColumnName, null, valueColumnNames);
    }

    public static String createIdentifierSelectStatement(String tableName, String identifierColumnName, String orderByColumnName, Iterable<String> valueColumnNames) {
        boolean flag = false;
        StringBuilder builder = new StringBuilder();
        for (String columnName : valueColumnNames) {
            if (!flag) {
                builder.append("select ");
                builder.append(columnName);
                builder.append("\n");
                flag = true;
                continue;
            }
            builder.append("     , ");
            builder.append(columnName);
            builder.append("\n");
        }
        builder.append("  from ");
        builder.append(tableName);
        builder.append("\n");
        builder.append(" where ");
        builder.append(identifierColumnName);
        builder.append(" = ?");
        builder.append("\n");
        if (!StringUtilities.isNullOrEmpty((String)orderByColumnName)) {
            builder.append(" order by ");
            builder.append(orderByColumnName);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String[] getTableTypes(DatabaseMetaData metaData, IApplicable<String> applicableType) throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        try (ResultSet resultSet = metaData.getTableTypes();){
            while (resultSet.next()) {
                String type = resultSet.getString(1);
                if (!applicableType.isApplicable((Object)type)) continue;
                types.add(type);
            }
        }
        return (String[])types.stream().toArray(String[]::new);
    }

    public static boolean create(Connection connection, String statementString) throws SQLException {
        try (Statement statement = connection.createStatement();){
            boolean bl = statement.execute(statementString);
            return bl;
        }
    }

    public static String toString(ResultSet resultSet) throws SQLException {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                values.add(DatabaseUtilities.toDebugString(resultSet.getObject(i + 1)));
            }
            return IterableUtilities.toString(values, (String)", ", s -> DatabaseUtilities.toDebugString(s));
        }
        catch (ConversionException exception) {
            throw new SQLException(exception);
        }
    }

    public static IBatchTransfer batchTransfer(Connection connection, String tableName, String[] identifierNames, String[] valueNames) {
        String selectExistsStatement = DatabaseUtilities.createSelectExistsStatement(tableName, identifierNames);
        String updateStatement = DatabaseUtilities.createUpdateStatement(tableName, identifierNames, valueNames);
        String insertStatement = DatabaseUtilities.createInsertStatement(tableName, identifierNames, valueNames);
        return DatabaseUtilities.batchTransfer(connection, selectExistsStatement, insertStatement, updateStatement);
    }

    public static IBatchTransfer batchTransfer(Connection connection, String selectExistsStatement, String insertStatement, String updateStatement) {
        int numberOfIdentifiers = DatabaseUtilities.numberOfQuestionMarks(selectExistsStatement);
        int numberOfColumns = DatabaseUtilities.numberOfQuestionMarks(insertStatement);
        return new BatchTransfer(connection, numberOfIdentifiers, numberOfColumns, selectExistsStatement, insertStatement, updateStatement);
    }

    private static String createInsertStatement(String tableName, String[] identifiers, String[] values) {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ");
        builder.append("'");
        builder.append(tableName);
        builder.append("'");
        builder.append(" (");
        boolean nameFlag = false;
        for (String identifier : identifiers) {
            if (nameFlag) {
                builder.append(", ");
            } else {
                nameFlag = true;
            }
            builder.append("'");
            builder.append(identifier);
            builder.append("'");
        }
        for (String value : values) {
            if (nameFlag) {
                builder.append(", ");
            } else {
                nameFlag = true;
            }
            builder.append("'");
            builder.append(value);
            builder.append("'");
        }
        builder.append(" )");
        builder.append(" values ");
        builder.append(" (");
        boolean valueflags = false;
        for (String identifier : identifiers) {
            if (valueflags) {
                builder.append(", ");
            } else {
                valueflags = true;
            }
            builder.append("?");
        }
        for (String value : values) {
            if (valueflags) {
                builder.append(", ");
            } else {
                valueflags = true;
            }
            builder.append("?");
        }
        builder.append(" )");
        return builder.toString();
    }

    private static String createUpdateStatement(String tableName, String[] identifiers, String[] values) {
        StringBuilder builder = new StringBuilder();
        builder.append("update ");
        builder.append("'");
        builder.append(tableName);
        builder.append("'");
        builder.append(" set ");
        boolean valueflags = false;
        for (String value : values) {
            if (valueflags) {
                builder.append(", ");
            } else {
                valueflags = true;
            }
            builder.append("'");
            builder.append(value);
            builder.append("' = ?");
        }
        builder.append(" )");
        boolean clauseFlag = false;
        for (String identifier : identifiers) {
            if (clauseFlag) {
                builder.append(" and ");
            } else {
                builder.append(" where ");
                clauseFlag = true;
            }
            builder.append("'");
            builder.append(identifier);
            builder.append("' = ?");
        }
        return builder.toString();
    }

    private static String createSelectExistsStatement(String tableName, String[] identifiers) {
        StringBuilder builder = new StringBuilder();
        builder.append("select count(*) ");
        builder.append("'");
        builder.append(tableName);
        builder.append("'");
        boolean flag = false;
        for (String identifier : identifiers) {
            if (flag) {
                builder.append(" and ");
            } else {
                builder.append(" where ");
                flag = true;
            }
            builder.append("'");
            builder.append(identifier);
            builder.append("' = ?");
        }
        return builder.toString();
    }

    private static int numberOfQuestionMarks(String string) {
        return (int)string.chars().filter(ch -> ch == 63).count();
    }

    public static void execute(Connection connection, File file) throws FileNotFoundException, IOException, SQLException {
        StringBuilder builder = new StringBuilder();
        Counter counter = new Counter(0L);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String trimed = line.trim();
                if (trimed.isBlank() || "COMMIT;".equalsIgnoreCase(trimed)) continue;
                builder.append(trimed);
                if (trimed.endsWith(";")) {
                    String statementString = builder.toString();
                    DatabaseUtilities.execute(connection, statementString.substring(0, statementString.length() - 1));
                    counter.increment();
                    if (!connection.getAutoCommit() && counter.value() == 500L) {
                        counter.set(0L);
                        connection.commit();
                    }
                    builder = new StringBuilder();
                    continue;
                }
                builder.append("\n");
            }
        }
        if (!connection.getAutoCommit() && counter.value() > 0L) {
            connection.commit();
        }
    }

    private static /* synthetic */ void lambda$results$15(IBooleanContainer flag, PreparedStatement statement) throws RuntimeException {
        try {
            flag.set(false);
            statement.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$result$6(PreparedStatement statement) throws RuntimeException {
        try {
            statement.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$foreach$3(IBooleanContainer flag, PreparedStatement statement) throws RuntimeException {
        try {
            flag.set(false);
            statement.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$results$2(IBooleanContainer flag, PreparedStatement statement) throws RuntimeException {
        try {
            flag.set(false);
            statement.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

