/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.anwiba.commons.jdbc.connection.IRegisterableDatabaseConnector;

public class DefaultDatabaseConnector
implements IRegisterableDatabaseConnector {
    private static final int TIMEOUT = 10;

    @Override
    public synchronized Connection connectReadOnly(String url, String userName, String password, int timeout) throws SQLException {
        return this.connect(url, userName, password, false, timeout, true);
    }

    @Override
    public Connection connectWritable(String url, String userName, String password, boolean isAutoCommitEnabled, int timeout) throws SQLException {
        return this.connect(url, userName, password, isAutoCommitEnabled, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection connect(String url, String userName, String password, boolean isAutoCommitEnabled, int timeout, boolean isReadOnly) throws SQLException {
        if (timeout == -1) {
            return this.createConnection(url, userName, password, isAutoCommitEnabled, isReadOnly);
        }
        int loginTimeout = DriverManager.getLoginTimeout();
        try {
            DriverManager.setLoginTimeout(timeout);
            Connection connection = this.createConnection(url, userName, password, isAutoCommitEnabled, isReadOnly);
            return connection;
        }
        finally {
            DriverManager.setLoginTimeout(loginTimeout);
        }
    }

    private Connection createConnection(String url, String user, String password, boolean isAutoCommitEnabled, boolean isReadOnly) throws SQLException {
        Connection connection = DriverManager.getConnection(url, user, password);
        connection.setAutoCommit(isAutoCommitEnabled);
        connection.setReadOnly(isReadOnly);
        return connection;
    }

    public boolean isApplicable(String context) {
        return true;
    }

    @Override
    public boolean isConnectable(String url, String userName, String password) {
        boolean bl;
        block8: {
            Connection connection = this.connectReadOnly(url, userName, password, 10);
            try {
                bl = true;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }
}

