/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.jdbc.constraint;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.anwiba.commons.jdbc.constraint.Constraint;
import net.anwiba.commons.jdbc.constraint.ConstraintType;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public class ConstraintsUtilities {
    public static Set<String> getIdentifierNames(Map<String, Constraint> constraints) {
        HashSet<String> result = new HashSet<String>();
        for (Constraint constraint : constraints.values()) {
            if (!constraint.isPrimaryKey()) continue;
            result.addAll(constraint.getColumnNames());
            break;
        }
        if (!result.isEmpty()) {
            return result;
        }
        Constraint uniqueConstraint = null;
        for (Constraint constraint : constraints.values()) {
            if (!Objects.equals((Object)ConstraintType.UNIQUE, (Object)constraint.getType())) continue;
            if (uniqueConstraint == null) {
                uniqueConstraint = constraint;
                continue;
            }
            if (constraint.getColumnNames().size() >= uniqueConstraint.getColumnNames().size()) continue;
            uniqueConstraint = constraint;
        }
        if (uniqueConstraint != null) {
            result.addAll(uniqueConstraint.getColumnNames());
        }
        return result;
    }

    public static boolean isPrimaryKey(Map<String, Constraint> constraints, String columnName) {
        for (Constraint constraint : constraints.values()) {
            if (!constraint.isPrimaryKey() || !constraint.contains(columnName)) continue;
            return true;
        }
        return false;
    }

    public static Constraint[] getColumnConstaints(final String columnName, Map<String, Constraint> constraints) {
        List columnConstraints = IterableUtilities.asList(constraints.values(), (IAcceptor)new IAcceptor<Constraint>(){

            public boolean accept(Constraint constraint) {
                return constraint.contains(columnName);
            }
        });
        return columnConstraints.toArray(new Constraint[columnConstraints.size()]);
    }

    public static boolean containsBooleanConstraints(final String name, Constraint[] constraints) {
        return IterableUtilities.containsAcceptedItems(Arrays.asList(constraints), (IAcceptor)new IAcceptor<Constraint>(){

            public boolean accept(Constraint constraint) {
                return constraint.getCondition() != null && constraint.getCondition().equals(name + " IN (0,1)");
            }
        });
    }
}

